/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.Hgvs;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesHgvsDnaDupIntegration
extends TestCasesBase {
    @Override
    protected void init() {
        super.init();
        this.minExons = 1;
        this.randSeed = 20141128;
        this.initRand();
    }

    @Test
    public void test_01_dup() {
        Gpr.debug("Test");
        String genome = "testHg19Chr17";
        String vcf = "tests/hgvs_dup.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        snpeff.setUpDownStreamLength(0);
        List<VcfEntry> results = snpeff.run(true);
        for (VcfEntry ve : results) {
            String hgvsCexp = ve.getInfo("HGVS_C") != null ? ve.getInfo("HGVS_C") : "";
            String trIdC = Hgvs.parseTranscript(hgvsCexp);
            hgvsCexp = Hgvs.removeTranscript(hgvsCexp);
            String hgvsPexp = ve.getInfo("HGVS_P") != null ? ve.getInfo("HGVS_P") : "";
            String trIdP = Hgvs.parseTranscript(hgvsPexp);
            hgvsPexp = Hgvs.removeTranscript(hgvsPexp);
            if (this.verbose) {
                System.out.println(ve);
                if (trIdC != null) {
                    System.out.println("\tExpected HGVS_C: " + trIdC + ":" + hgvsCexp);
                }
                if (trIdP != null) {
                    System.out.println("\tExpected HGVS_P: " + trIdP + ":" + hgvsPexp + "\n");
                }
            }
            boolean okC = false;
            boolean okP = false;
            for (VcfEffect veff : ve.parseEffects()) {
                String hgvsPactual;
                String trId = veff.getTranscriptId();
                String hgvsCactual = veff.getHgvsDna() != null ? veff.getHgvsDna() : "";
                String string2 = hgvsPactual = veff.getHgvsProt() != null ? veff.getHgvsProt() : "";
                if (this.verbose) {
                    System.out.println("\t" + veff + "\n\t\tEFF    : " + veff.getEffectsStr() + "\n\t\tHGVS_C : " + hgvsCactual + "\n\t\tHGVS_P : " + hgvsPactual + "\n");
                }
                if (trId != null && trId.equals(trIdC)) {
                    Assert.assertEquals(hgvsCexp, hgvsCactual);
                    okC = true;
                }
                if (trId == null || !trId.equals(trIdP)) continue;
                Assert.assertEquals(hgvsPexp, hgvsPactual);
                okP = true;
            }
            Assert.assertTrue("HGVS (DNA) not found: '" + hgvsCexp + "'", okC);
            if (hgvsPexp.isEmpty()) continue;
            Assert.assertTrue("HGVS (Protein) not found: '" + hgvsPexp + "'", okP);
        }
    }
}

