/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;

public class TestCasesHgvsBase {
    boolean debug;
    boolean verbose;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence;
    char[] chromoBases;

    public TestCasesHgvsBase() {
        this.verbose = this.debug = false;
        this.chromoSequence = "";
        this.init();
    }

    int exonBase(char[] bases, int pos, int direction) {
        int posBefore;
        int posAfter;
        int countAfter = 0;
        int countBefore = 0;
        for (posAfter = pos; posAfter >= 0 && posAfter < bases.length && bases[posAfter] == '-'; posAfter += direction) {
            ++countAfter;
        }
        for (posBefore = pos; posBefore >= 0 && posBefore < bases.length && bases[posBefore] == '-'; posBefore -= direction) {
            ++countBefore;
        }
        if (countBefore <= countAfter) {
            return posBefore;
        }
        return posAfter;
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor(false, true);
    }

    void initRand() {
        this.rand = new Random(20130708L);
    }

    void initSnpEffPredictor(boolean addUtrs, boolean onlyPlusStrand) {
        if (this.config == null) {
            this.config = new Config("testCase", "snpEff.config");
        }
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, this.rand, maxGeneLen, maxTranscripts, maxExons);
        sepf.setForcePositiveStrand(onlyPlusStrand);
        sepf.setAddUtrs(addUtrs);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.getSnpEffectPredictor().setSpliceRegionExonSize(0);
        this.config.getSnpEffectPredictor().setSpliceRegionIntronMin(0);
        this.config.getSnpEffectPredictor().setSpliceRegionIntronMax(0);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    String intronHgsv(char[] bases, int j, int pos, String refStr, String altStr) {
        int step2;
        if (this.transcript.isStrandMinus()) {
            refStr = GprSeq.wc(refStr);
            altStr = GprSeq.wc(altStr);
        }
        int exonBase = this.exonBase(bases, j, this.transcript.isStrandMinus() ? -1 : 1);
        int exonDist = (j - exonBase) * (this.transcript.isStrandMinus() ? -1 : 1);
        char type = bases[exonBase];
        String typeStr = "";
        int basesCount = 0;
        int n = step2 = this.transcript.isStrandPlus() ? 1 : -1;
        if (type == '5') {
            typeStr = "-";
            for (int i = exonBase; i >= 0 && i < bases.length; i += step2) {
                if (bases[i] == type) {
                    ++basesCount;
                    continue;
                }
                if (bases[i] == '-') {
                    continue;
                }
                break;
            }
        } else if (type == '3') {
            typeStr = "*";
            for (int i = exonBase; i >= 0 && i < bases.length; i -= step2) {
                if (bases[i] == type) {
                    ++basesCount;
                    continue;
                }
                if (bases[i] == '-') {
                    continue;
                }
                break;
            }
        } else if (type == '>' || type == '<') {
            for (int i = exonBase; i >= 0 && i < bases.length; i -= step2) {
                if (bases[i] == type) {
                    ++basesCount;
                    continue;
                }
                if (bases[i] == '-' || bases[i] == '>' || bases[i] == '<') {
                    continue;
                }
                break;
            }
        } else {
            throw new RuntimeException("Unexpected base type '" + bases[exonBase] + "'");
        }
        return "c." + typeStr + basesCount + (exonDist >= 0 ? "+" : "") + exonDist + refStr + ">" + altStr;
    }

    public void snpEffect(String genomeVer, String vcfFile) {
        String[] args = new String[]{"-classic", "-hgvs", "-ud", "0", genomeVer, vcfFile};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        int entryNum = 1;
        for (VcfEntry vcfEntry : list2) {
            boolean found = false;
            String hgvsStr = vcfEntry.getInfo("HGVS");
            String trId = vcfEntry.getInfo("TR");
            HashSet<String> hgvsExpected = new HashSet<String>();
            for (String h : hgvsStr.split(",")) {
                if (h.indexOf(58) > 0) {
                    h = h.substring(h.indexOf(58) + 1);
                }
                hgvsExpected.add(h);
            }
            if (this.debug) {
                System.err.println(entryNum + "\t" + vcfEntry);
            }
            StringBuilder sb = new StringBuilder();
            for (VcfEffect eff : vcfEntry.parseEffects()) {
                if (trId == null || trId.isEmpty() || !trId.equals(eff.getTranscriptId())) continue;
                String hgvsReal = eff.getAa();
                String line = "\tHGVS: " + hgvsExpected.contains(hgvsReal) + "\tExpected: " + hgvsExpected + "\tSnpEFf: " + eff.getAa() + "\t" + eff.getGenotype() + "\t" + eff;
                sb.append(line + "\n");
                if (this.debug) {
                    System.err.println(line);
                }
                if (!hgvsExpected.contains(hgvsReal)) continue;
                found = true;
            }
            if (!found) {
                System.err.println("HGVS not found in variant\n" + vcfEntry + "\n" + sb);
                throw new RuntimeException("HGVS not found in variant\n" + vcfEntry);
            }
            ++entryNum;
        }
    }
}

