/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.integration.CompareToVep;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesHgvs {
    boolean debug;
    boolean verbose;

    public TestCasesHgvs() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genomeName = "testHg3775Chr1";
        String vcf = "tests/hgvs_1.vep.vcf";
        CompareToVep comp = new CompareToVep(genomeName, this.verbose);
        comp.setCompareHgvs();
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        String genomeName = "testHg3775Chr1";
        String vcf = "tests/ensembl_hgvs_intron.1.vep.vcf";
        CompareToVep comp = new CompareToVep(genomeName, this.verbose);
        comp.setCompareHgvs();
        comp.setStrict(true);
        comp.setOnlyProtein(true);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        String genomeName = "testHg3775Chr1";
        String vcf = "tests/ensembl_hgvs_intron.outsideCds.vep.vcf";
        CompareToVep comp = new CompareToVep(genomeName, this.verbose);
        comp.setCompareHgvs();
        comp.setStrict(true);
        comp.setOnlyProtein(true);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        String genomeName = "testHg3775Chr1";
        String vcf = "tests/ensembl_hgvs_intron.vep.vcf";
        CompareToVep comp = new CompareToVep(genomeName, this.verbose);
        comp.setCompareHgvs();
        comp.setStrict(true);
        comp.setOnlyProtein(true);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_06() {
        Gpr.debug("Test");
        String genomeName = "testHg3775Chr1";
        String vcf = "tests/ensembl_hgvs_intron.within_cds.vep.vcf";
        CompareToVep comp = new CompareToVep(genomeName, this.verbose);
        comp.setCompareHgvs();
        comp.setStrict(true);
        comp.setOnlyProtein(true);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_10_MixedVep_HGVS() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr1";
        String vcf = "tests/mixed_10_hgvs.vep.vcf";
        CompareToVep comp = new CompareToVep(genome, this.verbose);
        comp.setCompareHgvs();
        comp.setOnlyProtein(true);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_11_Hg19Hgvs() {
        Gpr.debug("Test");
        String genome = "testHg19Hgvs";
        String vcf = "tests/hgvs_counsyl.vcf";
        CompareToVep comp = new CompareToVep(genome, this.verbose);
        comp.setCompareHgvs();
        comp.setCompareHgvsProt(false);
        comp.setShiftHgvs(true);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_11_Hg19Hgvs_noShift() {
        Gpr.debug("Test");
        String genome = "testHg19Hgvs";
        String vcf = "tests/hgvs_counsyl.noShift.vcf";
        CompareToVep comp = new CompareToVep(genome, this.verbose);
        comp.setCompareHgvs();
        comp.setCompareHgvsProt(false);
        comp.setShiftHgvs(false);
        comp.compareVep(vcf);
        if (this.verbose) {
            System.out.println(comp);
        }
        Assert.assertTrue("No comparissons were made!", comp.checkComapred());
    }

    @Test
    public void test_12_BRCA_Splice_15_Hgvs() {
        Gpr.debug("Test");
        int spliceSize = 15;
        String genome = "test_BRCA";
        String vcf = "tests/test_BRCA_splice_15.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        snpeff.setSpliceSiteSize(spliceSize);
        snpeff.setUpDownStreamLength(0);
        snpeff.setShiftHgvs(false);
        List<VcfEntry> results = snpeff.run(true);
        VcfEntry ve = results.get(0);
        boolean ok = false;
        for (VcfEffect veff : ve.parseEffects()) {
            if (this.verbose) {
                Gpr.debug("\t" + veff + "\n\t\ttranscript: " + veff.getTranscriptId() + "\n\t\tHgvs (DNA): " + veff.getHgvsDna());
            }
            ok |= veff.getTranscriptId().equals("ENST00000544455") && veff.getHgvsDna().equals("c.1909+12delT");
        }
        Assert.assertTrue(ok);
    }

    @Test
    public void test_14_splice_region_Hgvs() {
        Gpr.debug("Test");
        String genome = "testHg19Chr1";
        String vcf = "tests/hgvs_splice_region.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        snpeff.setUpDownStreamLength(0);
        List<VcfEntry> results = snpeff.run(true);
        VcfEntry ve = results.get(0);
        boolean ok = false;
        for (VcfEffect veff : ve.parseEffects()) {
            if (this.verbose) {
                System.out.println("\t" + veff + "\t" + veff.getEffectsStr() + "\t" + veff.getHgvsDna());
            }
            ok |= veff.hasEffectType(EffectType.SPLICE_SITE_REGION) && veff.getTranscriptId().equals("NM_001232.3") && veff.getHgvsDna().equals("c.420+6T>C");
        }
        Assert.assertTrue(ok);
    }

    @Test
    public void test_15_hgvs_INS_intergenic() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr22";
        String vcf = "tests/test_hgvs_INS_intergenic.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_ANN_1);
        List<VcfEntry> results = snpeff.run(true);
        VcfEntry ve = results.get(0);
        boolean ok = false;
        for (VcfEffect veff : ve.parseEffects()) {
            if (this.verbose) {
                System.out.println("\t" + veff + "\t" + veff.getEffectsStr() + "\t" + veff.getHgvsDna());
            }
            ok |= veff.hasEffectType(EffectType.INTERGENIC) && veff.getHgvsDna().equals("n.15070000_15070001insT");
        }
        Assert.assertTrue("Error in HGVS annotaiton", ok);
    }
}

