/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCasesGtf22 {
    boolean verbose = false;
    int exonToStringVersionOri;

    @After
    public void after() {
        Exon.ToStringVersion = this.exonToStringVersionOri;
    }

    @Before
    public void before() {
        this.exonToStringVersionOri = Exon.ToStringVersion;
        Exon.ToStringVersion = 1;
    }

    public void buildAndCompare(String genome, String gtf22, String fastaFile, String resultFile) {
        String expectedResult = Gpr.readFile(resultFile).trim();
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGtf22 fgtf22 = new SnpEffPredictorFactoryGtf22(config);
        fgtf22.setFileName(gtf22);
        fgtf22.setVerbose(this.verbose);
        if (fastaFile != null) {
            fgtf22.setFastaFile(fastaFile);
        } else {
            fgtf22.setReadSequences(false);
        }
        SnpEffectPredictor sep = fgtf22.create();
        String result2 = this.show(sep.getGenome()).trim();
        if (this.verbose) {
            System.out.println(result2);
        }
        Assert.assertEquals(Gpr.noSpaces(expectedResult), Gpr.noSpaces(result2));
    }

    String show(Genome genome) {
        StringBuilder sb = new StringBuilder();
        sb.append(genome.getVersion() + "\n");
        for (Chromosome chr : genome) {
            sb.append(chr + "\n");
        }
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (Gene gene : genome.getGenes()) {
            genes.add(gene);
        }
        for (Gene gene : genes) {
            for (Transcript tr : gene.sortedStrand()) {
                tr.setProteinCoding(false);
            }
            sb.append(gene);
            for (Transcript tr : gene.sortedStrand()) {
                sb.append("\t\tCDS '" + tr.getId() + "': " + tr.cds() + "\n");
            }
        }
        return sb.toString();
    }

    @Test
    public void testCaseHg37_61_ENST00000250838() {
        Gpr.debug("Test");
        String genome = "testHg37.61";
        String gtfFile = "tests/ENST00000250838.gtf";
        String fastaFile = "tests/chrY.fa.gz";
        String resultFile = "tests/ENST00000250838.txt";
        this.buildAndCompare(genome, gtfFile, fastaFile, resultFile);
    }

    @Test
    public void testCaseHg37_61_ENST00000331397() {
        Gpr.debug("Test");
        String genome = "testHg37.61";
        String gtfFile = "tests/ENST00000331397.gtf22";
        String fastaFile = "tests/chrY.fa.gz";
        String resultFile = "tests/ENST00000331397.txt";
        this.buildAndCompare(genome, gtfFile, fastaFile, resultFile);
    }

    @Test
    public void testCaseMm37_61_ENSMUSG00000051951() {
        Gpr.debug("Test");
        String genome = "testMm37.61";
        String gtfFile = "tests/ENSMUSG00000051951.gtf";
        String resultFile = "tests/ENSMUSG00000051951.txt";
        this.buildAndCompare(genome, gtfFile, null, resultFile);
    }

    @Test
    public void testCaseMm37_61_ENSMUST00000070533() {
        Gpr.debug("Test");
        String genome = "testMm37.61";
        String gtfFile = "tests/ENSMUST00000070533.gtf";
        String resultFile = "tests/ENSMUST00000070533.txt";
        this.buildAndCompare(genome, gtfFile, null, resultFile);
    }
}

