/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff3;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCasesGff3 {
    boolean verbose = false;
    int exonToStringVersionOri;

    @After
    public void after() {
        Exon.ToStringVersion = this.exonToStringVersionOri;
    }

    @Before
    public void before() {
        this.exonToStringVersionOri = Exon.ToStringVersion;
        Exon.ToStringVersion = 1;
    }

    public SnpEffectPredictor buildAndCompare(String genome, String gff3File, String resultFile, boolean readSeqs, boolean createRandSequences) {
        String expectedResult = resultFile == null ? "" : Gpr.readFile(resultFile).trim();
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGff3 fgff3 = new SnpEffPredictorFactoryGff3(config);
        fgff3.setVerbose(this.verbose);
        fgff3.setFileName(gff3File);
        fgff3.setReadSequences(readSeqs);
        fgff3.setCreateRandSequences(createRandSequences);
        fgff3.setRandom(new Random(20140410L));
        SnpEffectPredictor sep = fgff3.create();
        String result2 = this.show(sep.getGenome()).trim();
        if (this.verbose || !Gpr.noSpaces(expectedResult).equals(Gpr.noSpaces(result2))) {
            System.out.println("Result:\n----------\n" + result2 + "\n----------\n");
        }
        Assert.assertEquals(Gpr.noSpaces(expectedResult), Gpr.noSpaces(result2));
        return sep;
    }

    String show(Genome genome) {
        StringBuilder sb = new StringBuilder();
        sb.append(genome.getVersion() + "\n");
        for (Chromosome chr : genome) {
            sb.append(chr + "\n");
        }
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (Gene gene : genome.getGenes()) {
            genes.add(gene);
        }
        Collections.sort(genes);
        for (Gene gene : genes) {
            sb.append(gene);
            for (Transcript tr : gene.sortedStrand()) {
                sb.append("\t\tCDS '" + tr.getId() + "': " + tr.cds() + "\n");
            }
        }
        return sb.toString();
    }

    @Test
    public void testCase_01_Exon_Simple() {
        Gpr.debug("Test");
        String genome = "testCase";
        String gff3File = "tests/exonSimple.gff3";
        String resultFile = "tests/exonSimple.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_02_ExonIn() {
        Gpr.debug("Test");
        String genome = "testCase";
        String gff3File = "tests/exonIn.gff3";
        String resultFile = "tests/exonIn.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_03_ExonOut() {
        Gpr.debug("Test");
        String genome = "testCase";
        String gff3File = "tests/exonOut.gff3";
        String resultFile = "tests/exonOut.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_04_AthalianaTair10_AT5G66790() {
        Gpr.debug("Test");
        String genome = "athalianaTair10";
        String gff3File = "tests/AT5G66790.gff3";
        String resultFile = "tests/AT5G66790.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_05_PaeruPA14muccA() {
        Gpr.debug("Test");
        String genome = "paeru.PA14";
        String gff3File = "tests/paeru.PA14.muccA.gff";
        String resultFile = "tests/paeru.PA14.muccA.txt";
        SnpEffectPredictor sep = this.buildAndCompare(genome, gff3File, resultFile, true, false);
        Gene gene = sep.getGenome().getGenes().iterator().next();
        Transcript tr = (Transcript)gene.iterator().next();
        tr.createSpliceSites(2, 0, 0, 0);
        List<SpliceSite> spliceSites = tr.spliceSites();
        Assert.assertEquals(0, spliceSites.size());
    }

    @Test
    public void testCase_06_Ppersica() {
        Gpr.debug("Test");
        String genome = "ppersica139";
        String gff3File = "tests/ppersica_139.gff";
        String resultFile = "tests/ppersica_139.txt";
        this.buildAndCompare(genome, gff3File, resultFile, false, false);
    }

    @Test
    public void testCase_07_Rice5() {
        Gpr.debug("Test");
        String genome = "testRice5";
        String gff3File = "tests/Os03t0150600.gff";
        String resultFile = "tests/Os03t0150600.txt";
        this.buildAndCompare(genome, gff3File, resultFile, false, false);
    }

    @Test
    public void testCase_08_Vibrio() {
        Gpr.debug("Test");
        String genome = "vibrio";
        String gff3File = "tests/vibrio.gff3";
        String resultFile = "tests/vibrio.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_09() {
        Gpr.debug("Test");
        String genome = "testAP";
        String gff3File = "tests/testAP_genes.gff.gz";
        String resultFile = "tests/testAP.txt";
        this.buildAndCompare(genome, gff3File, resultFile, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCase_09_AP() {
        Gpr.debug("Test");
        String genome = "testAP";
        String gff3File = "tests/testAP_genes.gff.gz";
        String resultFile = "tests/testAP.txt";
        PrintStream errOri = System.err;
        ByteArrayOutputStream myErr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(myErr));
        try {
            SnpEffPredictorFactory.MIN_TOTAL_FRAME_COUNT = 1;
            this.buildAndCompare(genome, gff3File, resultFile, true, false);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        finally {
            System.setErr(errOri);
        }
        System.err.println("STDERR:\n" + myErr);
        Assert.assertTrue(myErr.toString().indexOf("WARNING: All frames are zero!") >= 0);
    }

    @Test
    public void testCase_10_MaizeZmB73() {
        Gpr.debug("Test");
        String genome = "testMaizeZmB73";
        String gff3File = "tests/testMaizeZmB73.gff3";
        String resultFile = "tests/testMaizeZmB73.txt";
        this.buildAndCompare(genome, gff3File, resultFile, false, true);
    }
}

