/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesExonFrame {
    boolean verbose = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genomeName = "testLukas";
        String[] args = new String[]{"build", "-noLog", "-gff3", genomeName};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        boolean ok = snpEff.run();
        Assert.assertTrue(ok);
        String configFile = "snpEff.config";
        Config config = new Config(genomeName, configFile);
        if (this.verbose) {
            System.out.println("Loading database");
        }
        SnpEffectPredictor snpEffectPredictor = config.loadSnpEffectPredictor();
        Transcript transcript = null;
        for (Gene gene : snpEffectPredictor.getGenome().getGenes()) {
            Iterator iterator2 = gene.iterator();
            while (iterator2.hasNext()) {
                Transcript tr;
                transcript = tr = (Transcript)iterator2.next();
            }
        }
        Assert.assertEquals(454126, transcript.getCdsStart());
        Assert.assertEquals(450599, transcript.getCdsEnd());
        String vcfFileName = "tests/testLukas.vcf";
        String[] argsEff = new String[]{"-classic", "-ud", "0", genomeName, vcfFileName};
        SnpEff cmd = new SnpEff(argsEff);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve.toStringNoGt());
            }
            EffectType expectedEffect = EffectType.valueOf(ve.getInfo("EXP_EFF"));
            String expectedAa = ve.getInfo("EXP_AA");
            String expectedCodon = ve.getInfo("EXP_CODON");
            boolean found = false;
            for (VcfEffect veff : ve.parseEffects()) {
                String eff = veff.getEffectType().toString();
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tExpecing: '" + (Object)((Object)expectedEffect) + "'\tFound: '" + eff + "'");
                    System.out.println("\t\tExpecing: '" + expectedAa + "'\tFound: '" + veff.getAa() + "'");
                    System.out.println("\t\tExpecing: '" + expectedCodon + "'\tFound: '" + veff.getCodon() + "'");
                }
                if (!veff.hasEffectType(expectedEffect) || veff.getAa() != null && !veff.getAa().isEmpty() && !expectedAa.equals(veff.getAa()) || veff.getCodon() != null && !veff.getCodon().isEmpty() && !expectedCodon.equals(veff.getCodon())) continue;
                found = true;
            }
            if (found) continue;
            throw new RuntimeException("Cannot find expected effect '" + (Object)((Object)expectedEffect) + "', amino acid change '" + expectedAa + "' and codon change '" + expectedCodon + "'");
        }
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genomeName = "testMacuminata";
        String[] args = new String[]{"build", "-noLog", genomeName};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        boolean ok = snpEff.run();
        Assert.assertTrue(ok);
    }
}

