/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesApply {
    public static boolean debug;
    public static boolean verbose;
    public static int SHOW_EVERY;

    @Test
    public void test_01_Exon_SNPs() {
        Gpr.debug("Test");
        Config config = new Config("testHg3765Chr22");
        SnpEffectPredictor snpEffectPredictor = config.loadSnpEffectPredictor();
        Random random = new Random(20130214L);
        Genome genome = snpEffectPredictor.getGenome();
        int count2 = 1;
        for (Gene g : genome.getGenes()) {
            if (!g.isProteinCoding()) continue;
            if (verbose) {
                System.out.println(g.getGeneName());
            }
            for (Transcript t2 : g) {
                if (verbose) {
                    System.out.println("\t" + t2.getId());
                }
                for (Exon ex : t2) {
                    String seq2 = ex.getSequence();
                    String string2 = seq2 = ex.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2);
                    if (random.nextInt(10) > 1 || ex.size() > 1000) continue;
                    if (verbose) {
                        System.out.println("\t\t" + ex.getId() + "\tStrand: " + ex.getStrand() + "\tSize: " + ex.size());
                    }
                    int i = ex.getStart();
                    int idx = 0;
                    while (i < ex.getEnd()) {
                        char ref;
                        char alt = ref = Character.toUpperCase(seq2.charAt(idx));
                        while (ref == (alt = GprSeq.randBase(random))) {
                        }
                        String altStr = alt + "";
                        String newSeq = seq2.substring(0, idx) + altStr + seq2.substring(idx + 1);
                        newSeq = ex.isStrandPlus() ? newSeq : GprSeq.reverseWc(newSeq);
                        newSeq = newSeq.toLowerCase();
                        Variant variant = new Variant((Marker)t2.getChromosome(), i, ref + "", alt + "", "");
                        Exon exNew = ex.apply(variant);
                        if (!exNew.getSequence().equals(newSeq)) {
                            throw new RuntimeException("Error:\n\t\tVariant   : " + variant + "\n\t\tOriginal  : " + ex + "\n\t\tNew       : " + exNew + "\n\t\tNew seq   : " + newSeq);
                        }
                        Gpr.showMark(count2++, 1000);
                        ++i;
                        ++idx;
                    }
                }
            }
        }
        System.err.println("");
    }

    @Test
    public void test_02_Exon_INS() {
        Gpr.debug("Test");
        Config config = new Config("testHg3765Chr22");
        SnpEffectPredictor snpEffectPredictor = config.loadSnpEffectPredictor();
        Random random = new Random(20130214L);
        Genome genome = snpEffectPredictor.getGenome();
        int count2 = 1;
        for (Gene g : genome.getGenes()) {
            if (!g.isProteinCoding()) continue;
            if (verbose) {
                System.out.println(g.getGeneName());
            }
            for (Transcript t2 : g) {
                if (verbose) {
                    System.out.println("\t" + t2.getId());
                }
                for (Exon ex : t2) {
                    String seq2 = ex.getSequence();
                    String string2 = seq2 = ex.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2);
                    if (random.nextInt(10) > 1 || ex.size() > 1000) continue;
                    if (verbose) {
                        System.out.println("\t\t" + ex.getId() + "\tStrand: " + ex.getStrand() + "\tSize: " + ex.size());
                    }
                    int i = ex.getStart();
                    int idx = 0;
                    while (i < ex.getEnd()) {
                        Exon exNew;
                        int insLen = 1 + random.nextInt(8);
                        StringBuilder altsb = new StringBuilder();
                        for (int j = 0; j < insLen; ++j) {
                            altsb.append(GprSeq.randBase(random));
                        }
                        String newSeq = idx > 0 ? seq2.substring(0, idx) + altsb.toString() + seq2.substring(idx) : altsb.toString() + seq2;
                        newSeq = ex.isStrandPlus() ? newSeq : GprSeq.reverseWc(newSeq);
                        newSeq = newSeq.toLowerCase();
                        Variant variant = new Variant((Marker)t2.getChromosome(), i, "", altsb.toString(), "");
                        if (debug) {
                            Gpr.debug("variant: " + (Object)((Object)variant.getVariantType()) + "\t" + variant);
                        }
                        if (!(exNew = ex.apply(variant)).getSequence().equals(newSeq)) {
                            String msg = "Error:\n\t\tIndex               : " + idx + "\n\t\tVariant             : " + variant + "\n\t\tOriginal            : " + ex + "\n\t\tSequence (expected) : " + newSeq + "'" + "\n\t\tSequence            : " + exNew.getSequence() + "'";
                            System.err.println(msg);
                            throw new RuntimeException(msg);
                        }
                        Assert.assertEquals(newSeq, exNew.getSequence());
                        Gpr.showMark(count2++, 1000);
                        ++i;
                        ++idx;
                    }
                }
            }
        }
        System.err.println("");
    }

    @Test
    public void test_03_Exon_DEL() {
        Gpr.debug("Test");
        Config config = new Config("testHg3765Chr22");
        SnpEffectPredictor snpEffectPredictor = config.loadSnpEffectPredictor();
        Random random = new Random(20130214L);
        Genome genome = snpEffectPredictor.getGenome();
        int count2 = 1;
        for (Gene g : genome.getGenes()) {
            if (!g.isProteinCoding()) continue;
            if (verbose) {
                System.out.println(g.getGeneName());
            }
            for (Transcript t2 : g) {
                if (verbose) {
                    System.out.println("\t" + t2.getId());
                }
                for (Exon ex : t2) {
                    String seq2 = ex.getSequence();
                    String string2 = seq2 = ex.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2);
                    if (random.nextInt(10) > 1 || ex.size() > 1000) continue;
                    if (verbose) {
                        System.out.println("\t\t" + ex.getId() + "\tStrand: " + ex.getStrand() + "\tSize: " + ex.size());
                    }
                    int i = ex.getStart();
                    int idx = 0;
                    while (i < ex.getEnd()) {
                        Exon exNew;
                        int delLen = 1 + random.nextInt(8);
                        int end = idx + delLen;
                        String ref = end < seq2.length() ? seq2.substring(idx, end) : seq2.substring(idx);
                        String newSeq = "";
                        if (idx > 0) {
                            newSeq = seq2.substring(0, idx);
                        }
                        newSeq = newSeq + (end < seq2.length() ? seq2.substring(end) : "");
                        newSeq = ex.isStrandPlus() ? newSeq : GprSeq.reverseWc(newSeq);
                        newSeq = newSeq.toLowerCase();
                        Variant variant = new Variant((Marker)t2.getChromosome(), i, ref, "", "");
                        if (debug) {
                            Gpr.debug("variant: " + (Object)((Object)variant.getVariantType()) + "\t" + variant);
                        }
                        String newExSeq = (exNew = ex.apply(variant)) != null ? exNew.getSequence() : "";
                        Assert.assertEquals(newSeq, newExSeq);
                        if (!newExSeq.equals(newSeq)) {
                            String msg = "Error:\n\t\tVariant   : " + variant + "\n\t\tOriginal  : " + ex + "\n\t\tNew       : " + exNew + "\n\t\tNew seq   : " + newSeq;
                            System.err.println(msg);
                            throw new RuntimeException(msg);
                        }
                        Gpr.showMark(count2++, 1000);
                        ++i;
                        ++idx;
                    }
                }
            }
        }
        System.err.println("");
    }

    @Test
    public void test_04_Exon_MNP() {
        Gpr.debug("Test");
        Config config = new Config("testHg3765Chr22");
        SnpEffectPredictor snpEffectPredictor = config.loadSnpEffectPredictor();
        Random random = new Random(20130214L);
        Genome genome = snpEffectPredictor.getGenome();
        int count2 = 1;
        for (Gene g : genome.getGenes()) {
            if (!g.isProteinCoding()) continue;
            if (verbose) {
                System.out.println(g.getGeneName());
            }
            for (Transcript t2 : g) {
                if (verbose) {
                    System.out.println("\t" + t2.getId());
                }
                for (Exon ex : t2) {
                    String seq2 = ex.getSequence();
                    String string2 = seq2 = ex.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2);
                    if (random.nextInt(10) > 1 || ex.size() > 1000) continue;
                    if (verbose) {
                        System.out.println("\t\t" + ex.getId() + "\tStrand: " + ex.getStrand() + "\tSize: " + ex.size());
                    }
                    int i = ex.getStart();
                    int idx = 0;
                    while (i < ex.getEnd()) {
                        Exon exNew;
                        StringBuilder refsb;
                        String ref;
                        StringBuilder altsb;
                        String alt;
                        int len = random.nextInt(9) + 1;
                        int end = idx + len;
                        do {
                            altsb = new StringBuilder();
                            refsb = new StringBuilder();
                            for (int j = 0; j < len; ++j) {
                                if (idx + j < seq2.length()) {
                                    refsb.append(seq2.charAt(idx + j));
                                } else {
                                    refsb.append(GprSeq.randBase(random));
                                }
                                altsb.append(GprSeq.randBase(random));
                            }
                            if (refsb.length() == altsb.length()) continue;
                            throw new RuntimeException("This should never happen!");
                        } while ((alt = altsb.toString().toUpperCase()).equals(ref = refsb.toString().toUpperCase()) || alt.charAt(0) == ref.charAt(0));
                        String newSeq = "";
                        if (idx > 0) {
                            newSeq = seq2.substring(0, idx);
                        }
                        int maxlen = Math.min(ex.getEnd() - i + 1, len);
                        newSeq = newSeq + altsb.substring(0, maxlen);
                        newSeq = newSeq + (end < seq2.length() ? seq2.substring(end) : "");
                        newSeq = ex.isStrandPlus() ? newSeq : GprSeq.reverseWc(newSeq);
                        newSeq = newSeq.toLowerCase();
                        Variant variant = new Variant((Marker)t2.getChromosome(), i, refsb.toString(), altsb.toString(), "");
                        if (debug) {
                            Gpr.debug("variant: " + variant);
                        }
                        if (!(exNew = ex.apply(variant)).getSequence().equals(newSeq)) {
                            String msg = "Error:\n\t\tVariant   : " + variant + "\n\t\tOriginal  : " + ex + "\n\t\tNew       : " + exNew + "\n\t\tNew seq   : " + newSeq;
                            System.err.println(msg);
                            throw new RuntimeException(msg);
                        }
                        Gpr.showMark(count2++, 1000);
                        ++i;
                        ++idx;
                    }
                }
            }
        }
        System.err.println("");
    }

    static {
        verbose = debug = false;
        SHOW_EVERY = 10;
    }
}

