/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesAnn
extends TestCasesBase {
    @Test
    public void test_01_VcfRawAlt() {
        Gpr.debug("Test");
        String[] args = new String[]{"testHg3775Chr1", "tests/test_ann_integration_01.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        HashSet<String> allelesExpected = new HashSet<String>();
        allelesExpected.add("AACACACACACACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACACACACACAC");
        HashSet<String> allelesReal = new HashSet<String>();
        for (VcfEntry vcfEntry : list2) {
            if (this.debug) {
                System.err.println(vcfEntry);
            }
            for (VcfEffect eff : vcfEntry.parseEffects()) {
                String allele = eff.getAllele();
                if (this.verbose) {
                    System.err.println("\t" + eff + "\n\t\tAllele: " + allele);
                }
                Assert.assertTrue("Unexpected allele '" + allele + "'", allelesExpected.contains(allele));
                allelesReal.add(allele);
            }
        }
        Assert.assertEquals(allelesExpected, allelesReal);
    }
}

