/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.List;

public class CreateSpliceSiteTestCase {
    StringBuilder out = new StringBuilder();

    public static void main(String[] args) {
        CreateSpliceSiteTestCase zzz = new CreateSpliceSiteTestCase();
        zzz.run();
    }

    void out(Exon exon, int from2, int to2, EffectType type) {
        StringBuilder sb = new StringBuilder();
        for (int i = from2; i <= to2; ++i) {
            sb.append(exon.getChromosomeName() + "\t" + (i + 1) + "\tA\tC\t+\t0\t0\t" + (Object)((Object)type) + "\n");
        }
        System.out.print(sb);
        this.out.append(sb.toString());
    }

    public void run() {
        Gpr.debug("Loading config files");
        Config config = new Config("testCase", "snpEff.config");
        config.loadSnpEffectPredictor();
        for (Gene gint : config.getGenome().getGenes()) {
            for (Transcript tr : gint) {
                List exons = tr.sortedStrand();
                for (Exon eint : exons) {
                    if (eint.size() <= 2) continue;
                    if (gint.isStrandPlus()) {
                        if (eint.getRank() > 1) {
                            this.out(eint, eint.getStart() - 2, eint.getStart() - 1, EffectType.SPLICE_SITE_ACCEPTOR);
                        } else {
                            this.out(eint, eint.getStart() - 2, eint.getStart() - 1, EffectType.UPSTREAM);
                        }
                        if (eint.getRank() < exons.size()) {
                            this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, EffectType.SPLICE_SITE_DONOR);
                            continue;
                        }
                        this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, EffectType.DOWNSTREAM);
                        continue;
                    }
                    if (eint.getRank() > 1) {
                        this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, EffectType.SPLICE_SITE_ACCEPTOR);
                    } else {
                        this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, EffectType.UPSTREAM);
                    }
                    if (eint.getRank() < exons.size()) {
                        this.out(eint, eint.getStart() - 2, eint.getStart() - 1, EffectType.SPLICE_SITE_DONOR);
                        continue;
                    }
                    this.out(eint, eint.getStart() - 2, eint.getStart() - 1, EffectType.DOWNSTREAM);
                }
            }
        }
        Gpr.toFile("/tmp/CreateSpliceSiteTestCase.txt", this.out.toString());
    }
}

