/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;

public class CompareToEnsembl {
    boolean throwException = false;
    boolean verbose = false;
    Random rand;
    Config config;
    Genome genome;
    SnpEffectPredictor snpEffectPredictor;

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            System.err.println("Usage: " + CompareToEnsembl.class.getSimpleName() + " genomeName ensemblFile [transcriptId]");
            System.exit(1);
        }
        String genomeName = args[0];
        String ensemblFile = args[1];
        String trName = null;
        if (args.length > 2) {
            trName = args[2];
        }
        CompareToEnsembl compareToEnsembl = new CompareToEnsembl(genomeName, false);
        compareToEnsembl.compareEnsembl(ensemblFile, trName);
    }

    public CompareToEnsembl(String genomeName, boolean throwException) {
        this.throwException = throwException;
        if (this.verbose) {
            Timer.showStdErr("Loading predictor");
        }
        this.config = new Config(genomeName, "snpEff.config");
        this.config.loadSnpEffectPredictor();
        this.snpEffectPredictor = this.config.getSnpEffectPredictor();
        this.genome = this.config.getGenome();
        this.snpEffectPredictor.buildForest();
    }

    String change2str(VariantEffect change) {
        String str = this.effTranslate(change.getEffectType());
        str = change.getCodonsRef().isEmpty() && change.getCodonsAlt().isEmpty() ? str + " -" : str + " " + change.getCodonsRef() + "/" + change.getCodonsAlt();
        str = change.getAaRef().isEmpty() && change.getAaAlt().isEmpty() ? str + " -" : (change.getAaRef().equals(change.getAaAlt()) ? str + " " + change.getAaAlt() : str + " " + change.getAaRef() + "/" + change.getAaAlt());
        return str;
    }

    public void compareEnsembl(String ensemblFile, String trName) {
        HashMap<Variant, String> seqChanges = this.readEnsemblFile(ensemblFile);
        ArrayList<Variant> list2 = new ArrayList<Variant>();
        list2.addAll(seqChanges.keySet());
        Collections.sort(list2);
        for (Variant seqChange : list2) {
            VariantEffects changes = this.snpEffectPredictor.variantEffect(seqChange);
            boolean ok = false;
            StringBuffer changesSb = new StringBuffer();
            StringBuffer changesAllSb = new StringBuffer();
            for (VariantEffect change : changes) {
                Interval tr = null;
                for (Marker m = change.getMarker(); m != null && tr == null; m = m.getParent()) {
                    if (!(m instanceof Transcript)) continue;
                    tr = (Transcript)m;
                }
                if (tr == null || trName != null && !tr.getId().equals(trName)) continue;
                String id = this.change2str(change);
                changesAllSb.append("\tSnpEff  :\t" + change + "\n");
                if (!id.equals(seqChange.getId())) continue;
                changesSb.append(id + "\t");
                ok = true;
            }
            if (!this.verbose) continue;
            if (ok && this.verbose) {
                System.out.println("OK   :\t" + seqChange + "\t'" + changesSb + "'\n\tEnsembl :\t" + seqChanges.get(seqChange) + "\n" + changesAllSb);
                continue;
            }
            String line = "DIFF :\t" + seqChange + "\t'" + changesSb + "'\n\tEnsembl :\t" + seqChanges.get(seqChange) + "\n" + changesAllSb;
            if (this.verbose) {
                System.out.println(line);
            }
            if (!this.throwException) continue;
            throw new RuntimeException(line);
        }
    }

    String effTranslate(EffectType eff) {
        switch (eff) {
            case UTR_5_PRIME: 
            case START_GAINED: {
                return "5PRIME_UTR";
            }
            case UTR_3_PRIME: {
                return "3PRIME_UTR";
            }
            case NON_SYNONYMOUS_START: 
            case START_LOST: {
                return "NON_SYNONYMOUS_CODING";
            }
            case INTRON: {
                return "INTRONIC";
            }
        }
        return eff.toString();
    }

    Transcript findTranscriptByName(String trName) {
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.getId().equals(trName)) continue;
                return tr;
            }
        }
        return null;
    }

    HashMap<Variant, String> readEnsemblFile(String fileName) {
        String[] lines2 = Gpr.readFile(fileName).split("\n");
        if (lines2.length <= 0) {
            throw new RuntimeException("Cannot open file '" + fileName + "' (or it's empty).");
        }
        HashMap<Variant, String> seqChanges = new HashMap<Variant, String>();
        for (String line : lines2) {
            Variant seqChange = this.str2seqChange(line);
            seqChanges.put(seqChange, line);
        }
        return seqChanges;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    Variant str2seqChange(String line) {
        try {
            String eff;
            String[] recs = line.split("\t");
            String[] chrPos = recs[0].split("_");
            Chromosome chromo = this.genome.getChromosome(chrPos[0]);
            int pos = Gpr.parseIntSafe(chrPos[1]) - 1;
            String alt = chrPos[2];
            if (chrPos[2].indexOf(47) > 0) {
                String[] ra = chrPos[2].split("/");
                alt = ra[1];
            }
            String ref = "A";
            for (char base : GprSeq.BASES) {
                ref = "" + base;
                if (!ref.equals(alt)) break;
            }
            if ((eff = recs[6]).indexOf(44) > 0) {
                eff = eff.split(",")[0];
            }
            String id = eff + " " + recs[11] + " " + recs[10];
            Variant seqChange = new Variant((Marker)chromo, pos, ref, alt, id);
            return seqChange;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing line:\n" + line, e);
        }
    }
}

