/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.collections.MultivalueHashMap;
import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.FrameType;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.List;

public class SnpEffPredictorFactoryRefSeq
extends SnpEffPredictorFactory {
    private final HashMap<String, String> biotypeById = new HashMap();
    public static final String CDS_STAT_COMPLETE = "cmpl";
    MultivalueHashMap<String, Gene> genesByName = new MultivalueHashMap();

    public SnpEffPredictorFactoryRefSeq(Config config) {
        super(config, 0);
        this.biotypeById.put("AC", "Alternate_Genomic");
        this.biotypeById.put("AP", "Alternate_Protein");
        this.biotypeById.put("NC", "Genomic   ");
        this.biotypeById.put("NG", "Incomplete_Genomic");
        this.biotypeById.put("NM", "mRNA");
        this.biotypeById.put("NP", "Protein");
        this.biotypeById.put("NR", "Non-coding_transcript");
        this.biotypeById.put("NT", "Intermediate_Genomic");
        this.biotypeById.put("NW", "Intermediate_Genomic");
        this.biotypeById.put("NZ", "Genomic");
        this.biotypeById.put("XM", "mRNA");
        this.biotypeById.put("XP", "Protein");
        this.biotypeById.put("XR", "Non-coding_transcript");
        this.biotypeById.put("YP", "Protein");
        this.biotypeById.put("ZP", "Protein");
        this.biotypeById.put("NS", "Genomic");
        this.frameType = FrameType.UCSC;
        this.frameCorrection = true;
    }

    String bioType(String id) {
        if (id.length() < 2) {
            return "";
        }
        String key = id.substring(0, 2);
        String biotype = this.biotypeById.get(key);
        return biotype != null ? biotype : "";
    }

    @Override
    public SnpEffectPredictor create() {
        try {
            if (this.fileName == null) {
                this.fileName = this.config.getBaseFileNameGenes() + ".refseq";
            }
            if (this.verbose) {
                System.out.print("Reading gene intervals file : '" + this.fileName + "'\n\t\t");
            }
            this.readRefSeqFile();
            this.beforeExonSequences();
            if (this.readSequences) {
                this.readExonSequences();
            } else if (this.createRandSequences) {
                this.createRandSequences();
            }
            this.finishUp();
            if (this.verbose) {
                System.out.println(this.config.getGenome());
            }
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    Gene findOrCreateGene(String geneName, String trId, Chromosome chromo, int start, int end, boolean strandMinus) {
        Gene gene2;
        Marker tr = new Marker(chromo, start, end, strandMinus, trId);
        List genes = (List)this.genesByName.get(geneName);
        int geneIndex = 0;
        if (genes != null) {
            for (Gene gene2 : genes) {
                if (!gene2.intersects(tr)) continue;
                if (start < gene2.getStart()) {
                    gene2.setStart(start);
                }
                if (gene2.getEnd() < end) {
                    gene2.setEnd(end);
                }
                return gene2;
            }
            geneIndex = genes.size() + 1;
        }
        String geneId = geneName + (geneIndex > 0 ? "." + geneIndex : "");
        gene2 = new Gene(chromo, start, end, strandMinus, geneId, geneName, this.bioType(trId));
        this.genesByName.add(geneName, gene2);
        this.add(gene2);
        return gene2;
    }

    boolean isProteinCoding(String id) {
        String biotype = this.bioType(id).toLowerCase();
        return biotype.equals("mrna") || biotype.equals("protein");
    }

    protected void readRefSeqFile() {
        try {
            int count2 = 0;
            BufferedReader reader = Gpr.reader(this.fileName);
            if (reader == null) {
                return;
            }
            this.lineNum = 1;
            while (reader.ready()) {
                String[] fields;
                this.line = reader.readLine();
                if (!this.line.startsWith("#") && (fields = this.line.split("\t")).length >= 16) {
                    String id = fields[1];
                    String chromoName = fields[2];
                    boolean strandMinus = fields[3].equals("-");
                    int txstart = this.parsePosition(fields[4]);
                    int txend = this.parsePosition(fields[5]) - 1;
                    int cdsStart = this.parsePosition(fields[6]);
                    int cdsEnd = this.parsePosition(fields[7]) - 1;
                    int exonCount = Gpr.parseIntSafe(fields[8]);
                    String exonStarts = fields[9];
                    String exonEnds = fields[10];
                    String geneName = fields[12];
                    String cdsStartStat = fields[13];
                    String cdsEndStat = fields[14];
                    String exonFrames = fields[15];
                    Chromosome chromo = this.getOrCreateChromosome(chromoName);
                    String trId = this.uniqueTrId(id);
                    Gene gene = this.findOrCreateGene(geneName, trId, chromo, txstart, txend, strandMinus);
                    Transcript tr = new Transcript(gene, txstart, txend, strandMinus, trId);
                    boolean markAsCoding = this.isProteinCoding(trId) && cdsStartStat.equals(CDS_STAT_COMPLETE) && cdsEndStat.equals(CDS_STAT_COMPLETE);
                    tr.setProteinCoding(markAsCoding);
                    this.add(tr);
                    String[] exStartStr = exonStarts.split(",");
                    String[] exEndStr = exonEnds.split(",");
                    String[] exFrameStr = exonFrames.split(",");
                    for (int i = 0; i < exonCount; ++i) {
                        int exStart = this.parsePosition(exStartStr[i]);
                        int exEnd = this.parsePosition(exEndStr[i]) - 1;
                        int exFrame = Gpr.parseIntSafe(exFrameStr[i]);
                        String exId = trId + ".ex." + (i + 1);
                        Exon ex = new Exon(tr, exStart, exEnd, strandMinus, exId, i);
                        exFrame = this.frameType.convertFrame(exFrame);
                        ex.setFrame(exFrame);
                        this.add(ex);
                        if (exStart > cdsEnd || exEnd < cdsStart) continue;
                        Cds cds = new Cds(tr, Math.max(cdsStart, exStart), Math.min(cdsEnd, exEnd), strandMinus, exId);
                        this.add(cds);
                    }
                    ++count2;
                    if (this.verbose) {
                        Gpr.showMark(count2, 100, "\t\t");
                    }
                }
                ++this.lineNum;
            }
            reader.close();
        }
        catch (Exception e) {
            Gpr.debug("Offending line (lineNum: " + this.lineNum + "): '" + this.line + "'");
            throw new RuntimeException(e);
        }
    }

    String uniqueTrId(String id) {
        if (!this.transcriptsById.containsKey(id)) {
            return id;
        }
        int i = 2;
        String trId;
        while (this.transcriptsById.containsKey(trId = id + "." + i)) {
            ++i;
        }
        return trId;
    }
}

