/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.HashSet;

public class SnpEffCmdGenes2Bed
extends SnpEff {
    HashSet<String> geneIds = new HashSet();
    String fileName = null;
    boolean onlyProteinCoding;
    int expandUpstreamDownstream = 0;

    public static void main(String[] args) {
        SnpEffCmdGenes2Bed conf2down = new SnpEffCmdGenes2Bed();
        conf2down.parseArgs(args);
        conf2down.run();
    }

    void loadGenes() {
        if (this.fileName != null) {
            String[] lines2;
            if (this.verbose) {
                Timer.showStdErr("Loading genes list from file '" + this.fileName + "'");
            }
            if ((lines2 = Gpr.readFile(this.fileName).split("\n")).length <= 0) {
                throw new RuntimeException("Cannot read file '" + this.fileName + "'");
            }
            for (String line : lines2) {
                String id = line.trim();
                if (id.isEmpty()) continue;
                this.geneIds.add(id);
            }
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length < 1) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-f")) {
                if (i + 1 < args.length) {
                    this.fileName = args[++i];
                    continue;
                }
                this.usage("Option '-f' without file argument");
                continue;
            }
            if (args[i].equals("-pc")) {
                this.onlyProteinCoding = true;
                continue;
            }
            if (args[i].equals("-ud")) {
                if (i + 1 < args.length) {
                    this.expandUpstreamDownstream = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                this.usage("Option '-ud' without file argument");
                continue;
            }
            if (this.genomeVer == null || this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
                continue;
            }
            this.geneIds.add(args[i]);
        }
    }

    @Override
    public boolean run() {
        boolean isEmpty2 = this.geneIds.size() <= 0;
        this.loadGenes();
        if (this.verbose) {
            Timer.showStdErr("Number of gene IDs to look up: " + this.geneIds.size());
            if (isEmpty2) {
                Timer.showStdErr("Empty list of IDs. Using all genes.");
            }
        }
        this.loadConfig();
        this.loadDb();
        Genome genome = this.config.getGenome();
        if (this.verbose) {
            Timer.showStdErr("Finding genes.");
        }
        int found = 0;
        int filtered = 0;
        System.out.println("#chr\tstart\tend\tgeneName;geneId");
        for (Gene g : genome.getGenesSortedPos()) {
            if (!isEmpty2 && !this.geneIds.contains(g.getId()) && !this.geneIds.contains(g.getGeneName())) continue;
            ++found;
            if (!this.onlyProteinCoding || g.isProteinCoding()) {
                int start = g.getStart() - this.expandUpstreamDownstream;
                int end = g.getEnd() + 1 + this.expandUpstreamDownstream;
                System.out.println(g.getChromosomeName() + "\t" + start + "\t" + end + "\t" + g.getGeneName() + ";" + g.getId());
                continue;
            }
            ++filtered;
        }
        if (this.verbose) {
            Timer.showStdErr("Done\n\tFound      : " + found + " / " + this.geneIds.size() + (filtered > 0 ? "\n\tFiltered out : " + filtered + " / " + found : ""));
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("Usage: " + SnpEffCmdGenes2Bed.class.getSimpleName() + " genomeVer [-f genes.txt | geneList]}");
        System.err.println("Options: ");
        System.err.println("\t-f <file.txt>  : A TXT file having one gene ID (or name) per line.");
        System.err.println("\t-pc            : Use only protein coding genes.");
        System.err.println("\t-ud <num>      : Expand gene interval upstream and downstream by 'num' bases.");
        System.err.println("\tgeneList       : A list of gene IDs or names. One per command line argument: geneId_1 geneId_2 geneId_3 ... geneId_N");
        System.exit(-1);
    }
}

