/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.binseq.GenomicSequences;
import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Intergenic;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class SnpEffectPredictor
implements Serializable {
    private static final long serialVersionUID = 4519418862303325081L;
    public static final int DEFAULT_UP_DOWN_LENGTH = 5000;
    public static final int HUGE_DELETION_SIZE_THRESHOLD = 1000000;
    public static final double HUGE_DELETION_RATIO_THRESHOLD = 0.01;
    boolean useChromosomes = true;
    int upDownStreamLength = 5000;
    int spliceSiteSize = 2;
    int spliceRegionExonSize = 3;
    int spliceRegionIntronMin = 3;
    int spliceRegionIntronMax = 8;
    Genome genome;
    Markers markers;
    IntervalForest intervalForest;

    public static SnpEffectPredictor load(Config config) {
        String snpEffPredFile = config.getFileSnpEffectPredictor();
        if (!Gpr.canRead(snpEffPredFile)) {
            throw new RuntimeException("\tERROR: Cannot read file '" + snpEffPredFile + "'.\n\tYou can try to download the database by running the following command:\n\t\tjava -jar snpEff.jar download " + config.getGenome().getVersion() + "\n");
        }
        MarkerSerializer ms = new MarkerSerializer(config.getGenome());
        Markers markers = ms.load(snpEffPredFile);
        Genome genome = null;
        for (Marker m : markers) {
            if (!(m instanceof Genome)) continue;
            genome = (Genome)m;
        }
        if (genome == null) {
            throw new RuntimeException("Genome not found. This should never happen!");
        }
        SnpEffectPredictor snpEffectPredictor = new SnpEffectPredictor(genome);
        for (Marker m : markers) {
            if (!(m instanceof Gene)) continue;
            Gene gene = (Gene)m;
            snpEffectPredictor.add(gene);
        }
        for (Marker m : markers) {
            if (m instanceof Genome || m instanceof Chromosome || m instanceof Gene || m instanceof Transcript || m instanceof Exon || m instanceof Cds || m instanceof Utr || m instanceof SpliceSite) continue;
            snpEffectPredictor.add(m);
        }
        return snpEffectPredictor;
    }

    public SnpEffectPredictor(Genome genome) {
        this.genome = genome;
        this.markers = new Markers();
    }

    public void add(Gene gene) {
        this.genome.getGenes().add(gene);
    }

    public void add(Marker marker) {
        this.markers.add(marker);
    }

    public void addAll(Markers markersToAdd) {
        for (Marker marker : markersToAdd) {
            this.markers.add(marker);
        }
    }

    public void buildForest() {
        this.intervalForest = new IntervalForest();
        if (this.useChromosomes) {
            for (Chromosome chr : this.genome) {
                this.intervalForest.add(chr);
            }
        }
        this.genome.getGenes().createCircularGenes();
        for (Gene gene : this.genome.getGenes()) {
            this.intervalForest.add(gene);
        }
        this.markers.add(this.createGenomicRegions());
        this.canonical();
        this.intervalForest.add(this.markers);
        this.intervalForest.build();
    }

    void canonical() {
        for (Gene g : this.genome.getGenes()) {
            g.canonical();
        }
    }

    public Markers createGenomicRegions() {
        Markers markers = new Markers();
        for (Marker upDownStream : this.genome.getGenes().createUpDownStream(this.upDownStreamLength)) {
            markers.add(upDownStream);
        }
        this.genome.getGenes().createSpliceSites(this.spliceSiteSize, this.spliceRegionExonSize, this.spliceRegionIntronMin, this.spliceRegionIntronMax);
        for (Intergenic intergenic : this.genome.getGenes().createIntergenic()) {
            markers.add(intergenic);
        }
        return markers;
    }

    public Gene getGene(String geneIntervalId) {
        return this.genome.getGenes().get(geneIntervalId);
    }

    public Genome getGenome() {
        return this.genome;
    }

    public IntervalForest getIntervalForest() {
        return this.intervalForest;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public int getSpliceRegionExonSize() {
        return this.spliceRegionExonSize;
    }

    public int getSpliceRegionIntronMax() {
        return this.spliceRegionIntronMax;
    }

    public int getSpliceRegionIntronMin() {
        return this.spliceRegionIntronMin;
    }

    public Transcript getTranscript(String trId) {
        for (Gene g : this.genome.getGenes()) {
            for (Transcript tr : g) {
                if (!tr.getId().equals(trId)) continue;
                return tr;
            }
        }
        return null;
    }

    public int getUpDownStreamLength() {
        return this.upDownStreamLength;
    }

    boolean isChromosomeMissing(Marker marker) {
        if (marker.getChromosome() == null) {
            return true;
        }
        String chrName = marker.getChromosomeName();
        Chromosome chr = this.genome.getChromosome(chrName);
        if (chr == null) {
            return true;
        }
        if (chr.size() < 1) {
            return true;
        }
        return !this.intervalForest.hasTree(chrName);
    }

    public void print() {
        System.out.println(this.genome);
        for (Gene gene : this.genome.getGenes().sorted()) {
            System.out.println(gene);
        }
        for (Marker marker : this.markers) {
            System.out.println(marker);
        }
    }

    public Markers query(Marker marker) {
        return this.intervalForest.query(marker);
    }

    public Gene queryClosestGene(Marker inputInterval) {
        int initialExtension = 1000;
        String chrName = inputInterval.getChromosomeName();
        Chromosome chr = this.genome.getChromosome(chrName);
        if (chr == null) {
            return null;
        }
        if (chr.size() > 0) {
            for (int extend = initialExtension; extend < chr.size(); extend *= 2) {
                int start = Math.max(inputInterval.getStart() - extend, 0);
                int end = inputInterval.getEnd() + extend;
                Marker extended = new Marker(chr, start, end, false, "");
                Markers markers = this.query(extended);
                Markers genes = new Markers();
                int minDist = Integer.MAX_VALUE;
                for (Marker m : markers) {
                    int dist;
                    if (!(m instanceof Gene) || (dist = m.distance(inputInterval)) >= minDist) continue;
                    genes.add(m);
                    minDist = dist;
                }
                if (genes.size() <= 0) continue;
                Gene minDistGene = null;
                for (Marker m : genes) {
                    int dist = m.distance(inputInterval);
                    if (dist != minDist) continue;
                    Gene gene = (Gene)m;
                    if (minDistGene == null) {
                        minDistGene = gene;
                        continue;
                    }
                    if (minDistGene.isProteinCoding() || !gene.isProteinCoding()) continue;
                    minDistGene = gene;
                }
                return minDistGene;
            }
        }
        return null;
    }

    public Markers queryDeep(Marker marker) {
        if (Config.get().isErrorOnMissingChromo() && this.isChromosomeMissing(marker)) {
            throw new RuntimeException("Chromosome missing for marker: " + marker);
        }
        boolean hitChromo = false;
        Markers hits = new Markers();
        Markers intersects = this.query(marker);
        if (intersects.size() > 0) {
            for (Marker m : intersects) {
                hits.add(m);
                if (m instanceof Chromosome) {
                    hitChromo = true;
                    continue;
                }
                if (!(m instanceof Gene)) continue;
                Gene gene = (Gene)m;
                hits.addAll(gene.query(marker));
            }
        }
        if (!hitChromo && Config.get().isErrorChromoHit()) {
            throw new RuntimeException("ERROR: Out of chromosome range. " + marker);
        }
        return hits;
    }

    public Set<String> regions(Marker marker, boolean showGeneDetails, boolean compareTemplate) {
        return this.regions(marker, showGeneDetails, compareTemplate, null);
    }

    public Set<String> regions(Marker marker, boolean showGeneDetails, boolean compareTemplate, String id) {
        if (Config.get().isErrorOnMissingChromo() && this.isChromosomeMissing(marker)) {
            throw new RuntimeException("Chromosome missing for marker: " + marker);
        }
        boolean hitChromo = false;
        HashSet<String> hits = new HashSet<String>();
        Markers intersects = this.query(marker);
        if (intersects.size() > 0) {
            for (Marker markerInt : intersects) {
                if (markerInt instanceof Chromosome) {
                    hitChromo = true;
                    hits.add(markerInt.getClass().getSimpleName());
                    continue;
                }
                if (markerInt instanceof Gene) {
                    Gene gene = (Gene)markerInt;
                    this.regionsAddHit(hits, gene, marker, showGeneDetails, compareTemplate);
                    for (Transcript tr : gene) {
                        if (id != null && !gene.getId().equals(id) && !tr.getId().equals(id) || !tr.intersects(marker)) continue;
                        this.regionsAddHit(hits, tr, marker, showGeneDetails, compareTemplate);
                        for (Utr utr : tr.getUtrs()) {
                            if (!utr.intersects(marker)) continue;
                            this.regionsAddHit(hits, utr, marker, showGeneDetails, compareTemplate);
                        }
                        for (Exon ex : tr) {
                            if (!ex.intersects(marker)) continue;
                            this.regionsAddHit(hits, ex, marker, showGeneDetails, compareTemplate);
                        }
                        for (Intron intron : tr.introns()) {
                            if (!intron.intersects(marker)) continue;
                            this.regionsAddHit(hits, intron, marker, showGeneDetails, compareTemplate);
                        }
                    }
                    continue;
                }
                if (id == null) {
                    this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
                    continue;
                }
                Transcript tr = (Transcript)markerInt.findParent(Transcript.class);
                if (tr != null && tr.getId().equals(id)) {
                    this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
                    continue;
                }
                Gene gene = (Gene)markerInt.findParent(Gene.class);
                if (gene == null || !gene.getId().equals(id)) continue;
                this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
            }
        }
        if (!hitChromo) {
            throw new RuntimeException("ERROR: Out of chromosome range. " + marker);
        }
        return hits;
    }

    void regionsAddHit(HashSet<String> hits, Marker hit2add, Marker marker, boolean showGeneDetails, boolean compareTemplate) {
        Gene gene;
        String hitStr = hit2add.getClass().getSimpleName();
        if (compareTemplate && (gene = (Gene)hit2add.findParent(Gene.class)) != null) {
            hitStr = hitStr + (hit2add.isStrandPlus() == marker.isStrandPlus() ? "_TEMPLATE_STRAND" : "_NON_TEMPLATE_STRAND");
        }
        if (showGeneDetails && hit2add instanceof Gene) {
            gene = (Gene)hit2add;
            hitStr = hitStr + "[" + gene.getBioType() + ", " + gene.getGeneName() + ", " + (gene.isProteinCoding() ? "protein" : "not-protein") + "]";
        }
        hits.add(hitStr);
    }

    public void removeNonCanonical() {
        for (Gene g : this.genome.getGenes()) {
            g.removeNonCanonical();
        }
    }

    public boolean removeUnverified() {
        boolean allRemoved = true;
        for (Gene g : this.genome.getGenes()) {
            allRemoved &= g.removeUnverified();
        }
        return allRemoved;
    }

    public int retainAllTranscripts(Set<String> trIds) {
        int total = 0;
        for (Gene g : this.genome.getGenes()) {
            total += g.keepTranscripts(trIds);
        }
        return total;
    }

    public int retainTranscriptsProtein() {
        int total = 0;
        for (Gene g : this.genome.getGenes()) {
            total += g.keepTranscriptsProtein();
        }
        return total;
    }

    public void save(Config config) {
        String databaseFile = config.getFileSnpEffectPredictor();
        this.save(databaseFile);
        GenomicSequences gs = this.genome.getGenomicSequences();
        gs.setVerbose(config.isVerbose());
        gs.save(config);
    }

    public void save(String fileName) {
        Markers markersToSave = new Markers();
        markersToSave.add(this.genome);
        for (Chromosome chr : this.genome) {
            markersToSave.add(chr);
        }
        for (Gene g : this.genome.getGenes()) {
            markersToSave.add(g);
        }
        markersToSave.add(this.getMarkers());
        markersToSave.save(fileName);
    }

    public void setSpliceRegionExonSize(int spliceRegionExonSize) {
        this.spliceRegionExonSize = spliceRegionExonSize;
    }

    public void setSpliceRegionIntronMax(int spliceRegionIntronMax) {
        this.spliceRegionIntronMax = spliceRegionIntronMax;
    }

    public void setSpliceRegionIntronMin(int spliceRegionIntronMin) {
        this.spliceRegionIntronMin = spliceRegionIntronMin;
    }

    public void setSpliceSiteSize(int spliceSiteSize) {
        this.spliceSiteSize = spliceSiteSize;
    }

    public void setUpDownStreamLength(int upDownStreamLength) {
        this.upDownStreamLength = upDownStreamLength;
    }

    public void setUseChromosomes(boolean useChromosomes) {
        this.useChromosomes = useChromosomes;
    }

    public int size() {
        if (this.intervalForest == null) {
            return 0;
        }
        return this.intervalForest.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genome.getVersion() + "\n");
        for (Chromosome chr : this.genome) {
            sb.append(chr + "\n");
        }
        sb.append(this.genome.getGenes());
        return sb.toString();
    }

    public VariantEffects variantEffect(Variant variant) {
        String chromoName;
        Chromosome chr;
        VariantEffects variantEffects = new VariantEffects();
        if (Config.get().isErrorOnMissingChromo() && this.isChromosomeMissing(variant)) {
            variantEffects.addErrorWarning(variant, VariantEffect.ErrorWarningType.ERROR_CHROMOSOME_NOT_FOUND);
            return variantEffects;
        }
        if (variant.isDel() && (chr = this.genome.getChromosome(chromoName = variant.getChromosomeName())) != null) {
            double ratio;
            double d = ratio = chr.size() > 0 ? (double)variant.size() / (double)chr.size() : 0.0;
            if (variant.size() > 1000000 || ratio > 0.01) {
                variantEffects.add(variant, chr, EffectType.CHROMOSOME_LARGE_DELETION, "");
                return variantEffects;
            }
        }
        Markers intersects = this.query(variant);
        boolean hitChromo = false;
        boolean hitSomething = false;
        for (Marker marker : intersects) {
            if (marker instanceof Chromosome) {
                hitChromo = true;
                continue;
            }
            if (variant.isNonRef()) {
                marker.variantEffectNonRef(variant, variantEffects);
            } else {
                marker.variantEffect(variant, variantEffects);
            }
            hitSomething = true;
        }
        if (!hitChromo) {
            Chromosome chr2 = this.genome.getChromosome(variant.getChromosomeName());
            if (variant.isIns() && variant.getStart() == chr2.getEnd() + 1) {
                variantEffects.add(variant, null, EffectType.CHROMOSOME_ELONGATION, "");
            } else if (Config.get().isErrorChromoHit()) {
                variantEffects.addErrorWarning(variant, VariantEffect.ErrorWarningType.ERROR_OUT_OF_CHROMOSOME_RANGE);
            }
        } else if (!hitSomething) {
            if (Config.get().isOnlyRegulation()) {
                variantEffects.add(variant, null, EffectType.NONE, "");
            } else {
                variantEffects.add(variant, null, EffectType.INTERGENIC, "");
            }
        }
        return variantEffects;
    }
}

