/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.Hgvs;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class HgvsProtein
extends Hgvs {
    public static boolean debug = false;
    int codonNum;
    int aaPos;
    String aaNew3;
    String aaOld3;

    public HgvsProtein(VariantEffect variantEffect) {
        super(variantEffect);
        this.codonNum = variantEffect.getCodonNum();
        this.marker = variantEffect.getMarker();
        if (this.marker != null) {
            if (this.codonNum >= 0) {
                this.aaPos = this.codonNum + 1;
            }
            CodonTable codonTable = this.marker.codonTable();
            String aaNew = variantEffect.getAaAlt();
            String aaOld = variantEffect.getAaRef();
            this.aaNew3 = aaNew == null || aaNew.isEmpty() || aaNew.equals("-") ? "" : codonTable.aaThreeLetterCode(aaNew);
            this.aaOld3 = aaOld == null || aaOld.isEmpty() || aaOld.equals("-") ? "" : codonTable.aaThreeLetterCode(aaOld);
        } else {
            this.aaPos = -1;
            this.aaOld3 = "";
            this.aaNew3 = "";
        }
    }

    protected String del() {
        return "del";
    }

    protected String delins() {
        return "delins" + this.aaNew3;
    }

    protected String dup() {
        return "dup";
    }

    protected String fs() {
        return "fs";
    }

    protected String ins() {
        return "ins" + this.aaNew3;
    }

    boolean isDel() {
        return !this.aaOld3.isEmpty() && this.aaNew3.isEmpty();
    }

    protected boolean isDuplication() {
        String aaRef = this.variantEffect.getAaRef().toUpperCase();
        String aaAlt = this.variantEffect.getAaAlt().toUpperCase();
        String dupAaRef = aaRef + aaRef;
        if (debug) {
            Gpr.debug("AA.Ref: '" + aaRef + "'\tAA.Alt: '" + aaAlt);
        }
        if (aaAlt.equals(dupAaRef)) {
            return true;
        }
        String protein = this.tr.protein();
        if (protein == null) {
            return false;
        }
        aaAlt = this.variantEffect.getAaNetChange();
        int aaEnd = this.variantEffect.getCodonNum();
        int aaStart = aaEnd - aaAlt.length();
        if (aaStart < 0 || aaEnd > protein.length()) {
            return false;
        }
        aaRef = protein.substring(aaStart, aaEnd);
        boolean dup = aaRef.equalsIgnoreCase(aaAlt);
        if (debug) {
            Gpr.debug("SEQUENCE [ " + aaStart + " , " + aaEnd + " ]: '" + aaRef + "'" + "\n\tAA Ref       : '" + this.variantEffect.getAaRef() + "'" + "\n\tAA Alt       : '" + this.variantEffect.getAaAlt() + "'" + "\n\tAA Alt (net) : '" + aaAlt + "'" + "\n\tDup?         : " + dup);
        }
        return dup;
    }

    boolean isFs() {
        return this.variantEffect.hasEffectType(EffectType.FRAME_SHIFT);
    }

    boolean isIns() {
        return this.aaOld3.isEmpty() && !this.aaNew3.isEmpty();
    }

    protected String pos(int codonNum) {
        if (codonNum < 0) {
            return null;
        }
        Transcript tr = this.variantEffect.getTranscript();
        String protSeq = tr.protein();
        if (codonNum >= protSeq.length()) {
            return null;
        }
        CodonTable codonTable = this.marker.codonTable();
        return codonTable.aaThreeLetterCode(protSeq.charAt(codonNum)) + (codonNum + 1);
    }

    String pos(int start, int end) {
        String posStart = this.pos(start);
        if (posStart == null) {
            return null;
        }
        if (start == end) {
            return posStart;
        }
        String posEnd = this.pos(end);
        if (posEnd == null) {
            return null;
        }
        return posStart + "_" + posEnd;
    }

    protected String posDel() {
        String posStart = this.pos(this.codonNum);
        if (posStart == null) {
            return null;
        }
        if (this.aaOld3 == null || this.aaOld3.isEmpty() || this.aaOld3.equals("-")) {
            return null;
        }
        if (this.aaOld3.length() == 3) {
            return posStart;
        }
        int end = this.codonNum + (this.aaOld3.length() - this.aaNew3.length()) / 3 - 1;
        String posEnd = this.pos(end);
        if (posEnd == null) {
            return null;
        }
        return posStart + "_" + posEnd;
    }

    protected String posDelIns() {
        String posStart = this.pos(this.codonNum);
        if (posStart == null) {
            return null;
        }
        if (this.variantEffect.hasEffectType(EffectType.FRAME_SHIFT)) {
            return posStart;
        }
        if (this.aaOld3 == null || this.aaOld3.isEmpty() || this.aaOld3.equals("-")) {
            this.aaOld3 = "";
        }
        if (this.aaOld3.length() == 3) {
            return posStart;
        }
        int end = this.codonNum + this.aaOld3.length() / 3 - 1;
        String posEnd = this.pos(end);
        if (posEnd == null) {
            return null;
        }
        return posStart + "_" + posEnd;
    }

    protected String posDup() {
        int start;
        int end;
        int netLen = this.aaNew3.length() / 3;
        if (netLen == 1) {
            start = end = this.codonNum - 1;
        } else {
            end = this.codonNum - 1;
            start = end - (netLen - 1);
        }
        return this.pos(start, end);
    }

    protected String posFs() {
        if (this.codonNum < 0) {
            return null;
        }
        Transcript tr = this.variantEffect.getTranscript();
        String protSeq = tr.protein();
        if (this.codonNum >= protSeq.length()) {
            return null;
        }
        CodonTable codonTable = this.marker.codonTable();
        if (!this.variant.isMixed()) {
            Transcript newTr = tr.apply(this.variant);
            String newProtSeq = newTr.protein();
            int len = Math.min(protSeq.length(), newProtSeq.length());
            for (int cn = this.codonNum; cn < len; ++cn) {
                char newAa;
                char aa = protSeq.charAt(cn);
                if (aa == (newAa = newProtSeq.charAt(cn))) continue;
                return codonTable.aaThreeLetterCode(aa) + (cn + 1);
            }
        }
        return codonTable.aaThreeLetterCode(protSeq.charAt(this.codonNum)) + (this.codonNum + 1);
    }

    protected String posIns() {
        int start = this.codonNum - 1;
        int end = this.codonNum;
        return this.pos(start, end);
    }

    protected String posSnpOrMnp() {
        return this.pos(this.codonNum);
    }

    void simplifyAminoAcids() {
        this.simplifyAminoAcidsLeft();
        this.simplifyAminoAcidsRight();
    }

    void simplifyAminoAcidsLeft() {
        while (!this.aaOld3.isEmpty() && !this.aaNew3.isEmpty()) {
            String an3;
            String ao3 = this.aaOld3.substring(0, 3);
            if (ao3.equals(an3 = this.aaNew3.substring(0, 3))) {
                this.aaOld3 = this.aaOld3.substring(3);
                this.aaNew3 = this.aaNew3.substring(3);
                ++this.codonNum;
                continue;
            }
            return;
        }
    }

    void simplifyAminoAcidsRight() {
        while (!this.aaOld3.isEmpty() && !this.aaNew3.isEmpty()) {
            int lastAaNewIdx;
            String an3;
            int lastAaOldIdx = this.aaOld3.length() - 3;
            String ao3 = this.aaOld3.substring(lastAaOldIdx);
            if (ao3.equals(an3 = this.aaNew3.substring(lastAaNewIdx = this.aaNew3.length() - 3))) {
                this.aaOld3 = this.aaOld3.substring(0, lastAaOldIdx);
                this.aaNew3 = this.aaNew3.substring(0, lastAaNewIdx);
                continue;
            }
            return;
        }
    }

    protected String snpOrMnp() {
        if (this.variantEffect.getAaRef().isEmpty() && this.variantEffect.getAaAlt().isEmpty()) {
            if (this.codonNum >= 0) {
                return "" + (this.codonNum + 1);
            }
            return null;
        }
        if (this.variantEffect.hasEffectType(EffectType.STOP_GAINED)) {
            return this.aaOld3 + this.aaPos + "*";
        }
        if (this.variantEffect.hasEffectType(EffectType.STOP_LOST)) {
            return this.aaOld3 + this.aaPos + this.aaNew3 + "ext*?";
        }
        if (this.variantEffect.hasEffectType(EffectType.START_LOST) || this.variantEffect.hasEffectType(EffectType.SYNONYMOUS_START) || this.variantEffect.hasEffectType(EffectType.NON_SYNONYMOUS_START)) {
            return this.aaOld3 + "1?";
        }
        if (this.variantEffect.hasEffectType(EffectType.SYNONYMOUS_CODING) || this.variantEffect.hasEffectType(EffectType.SYNONYMOUS_STOP)) {
            return this.aaOld3 + this.aaPos + this.aaNew3;
        }
        return this.aaOld3 + this.aaPos + this.aaNew3;
    }

    public String toString() {
        if (this.variant == null || this.marker == null) {
            return null;
        }
        if (!this.variant.isSnp() && !this.variant.isMnp()) {
            this.simplifyAminoAcids();
        }
        String pos = "";
        String protChange = "";
        if (!this.variant.isVariant()) {
            return "";
        }
        if (this.variant.isSnp() || this.variant.isMnp()) {
            protChange = this.snpOrMnp();
            pos = "";
        } else if (this.isFs()) {
            protChange = this.fs();
            pos = this.posFs();
        } else if (this.isIns()) {
            this.duplication = this.isDuplication();
            if (this.duplication) {
                protChange = this.dup();
                pos = this.posDup();
            } else {
                protChange = this.ins();
                pos = this.posIns();
            }
        } else if (this.isDel()) {
            protChange = this.del();
            pos = this.posDel();
        } else {
            protChange = this.delins();
            pos = this.posDelIns();
        }
        if (protChange == null || pos == null) {
            return null;
        }
        return "p." + pos + protChange;
    }
}

