/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.snpEffect.Hgvs;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public class HgvsDna
extends Hgvs {
    public static boolean debug = false;

    public HgvsDna(VariantEffect variantEffect) {
        super(variantEffect);
    }

    protected String codingPrefix() {
        return this.tr != null && this.tr.isProteinCoding() ? "c." : "n.";
    }

    protected String dnaBaseChange() {
        switch (this.variant.getVariantType()) {
            case SNP: {
                if (this.strandPlus) {
                    return this.variant.getReference() + ">" + this.variant.getAlt();
                }
                return GprSeq.reverseWc(this.variant.getReference()) + ">" + GprSeq.reverseWc(this.variant.getAlt());
            }
            case MNP: {
                String alt;
                String ref;
                if (this.strandPlus) {
                    ref = this.variant.getReference();
                    alt = this.variant.getAlt();
                } else {
                    ref = GprSeq.reverseWc(this.variant.getReference());
                    alt = GprSeq.reverseWc(this.variant.getAlt());
                }
                return "del" + ref + "ins" + alt;
            }
            case INS: 
            case DEL: {
                if (this.variant.size() > 100) {
                    return "";
                }
                String netChange = this.variant.netChange(false);
                if (this.strandPlus) {
                    return netChange;
                }
                return GprSeq.reverseWc(netChange);
            }
            case MIXED: {
                if (this.strandPlus) {
                    return "del" + this.variant.getReference() + "ins" + this.variant.getAlt();
                }
                return "del" + GprSeq.reverseWc(this.variant.getReference()) + "ins" + GprSeq.reverseWc(this.variant.getAlt());
            }
            case INTERVAL: {
                return "";
            }
        }
        throw new RuntimeException("Unimplemented method for variant type " + (Object)((Object)this.variant.getVariantType()));
    }

    boolean isDownstream(int pos) {
        if (this.tr.isStrandPlus()) {
            return this.tr.getEnd() < pos;
        }
        return pos < this.tr.getStart();
    }

    protected boolean isDuplication() {
        int send2;
        int sstart;
        if (!this.variant.isIns()) {
            return false;
        }
        String seq2 = null;
        int len = this.variant.getAlt().length();
        if (this.strandPlus) {
            sstart = Math.max(0, this.variant.getStart() - len);
            send2 = this.variant.getStart() - 1;
        } else {
            sstart = this.variant.getStart();
            send2 = sstart + (len - 1);
        }
        Marker m = new Marker(this.variant.getParent(), sstart, send2, false, "");
        Exon ex = this.variantEffect.getExon();
        if (ex != null && ex.includes(m)) {
            if (debug) {
                Gpr.debug("Variant: " + this.variant + "\n\tmarker: " + m.toStr() + "\tsstart:" + sstart + "\tsend: " + send2 + "\n\texon: " + ex + "\n\tstrand: " + (this.strandPlus ? "+" : "-"));
            }
            seq2 = ex.getSequence(m);
            if (debug) {
                Gpr.debug("Sequence (Exon)  [ " + sstart + " , " + send2 + " ]: '" + seq2 + "'\talt: '" + this.variant.getAlt() + "'\tsequence (+ strand): " + (ex.isStrandPlus() ? ex.getSequence() : GprSeq.reverseWc(ex.getSequence())));
            }
        }
        if (seq2 == null) {
            seq2 = this.genome.getGenomicSequences().querySequence(m);
            if (debug) {
                Gpr.debug("Sequence (Genome) [ " + sstart + " , " + send2 + " ]: '" + seq2 + "'\talt: '" + this.variant.getAlt() + "'\tsequence (+ strand): " + seq2);
            }
        }
        if (seq2 == null) {
            return false;
        }
        return seq2.equalsIgnoreCase(this.variant.getAlt());
    }

    boolean isUpstream(int pos) {
        if (this.tr.isStrandPlus()) {
            return pos < this.tr.getStart();
        }
        return this.tr.getEnd() < pos;
    }

    protected String pos() {
        int posStart = -1;
        int posEnd = -1;
        int variantPosStart = this.strandPlus ? this.variant.getStart() : this.variant.getEnd();
        switch (this.variant.getVariantType()) {
            case SNP: {
                posStart = posEnd = variantPosStart;
                break;
            }
            case MNP: {
                posStart = variantPosStart;
                posEnd = posStart + (this.strandPlus ? 1 : -1) * (this.variant.size() - 1);
                break;
            }
            case INS: {
                posStart = variantPosStart;
                if (this.duplication) {
                    int lenAlt = this.variant.getAlt().length();
                    if (lenAlt == 1) {
                        posEnd = posStart += this.strandPlus ? -1 : 0;
                        break;
                    }
                    if (this.strandPlus) {
                        posEnd = posStart - 1;
                        posStart -= lenAlt;
                        break;
                    }
                    posEnd = posStart;
                    posStart += lenAlt - 1;
                    break;
                }
                if (this.strandPlus) {
                    posEnd = posStart--;
                    break;
                }
                posEnd = posStart - 1;
                break;
            }
            case DEL: 
            case MIXED: {
                if (this.strandPlus) {
                    posStart = this.variant.getStart();
                    posEnd = this.variant.getEnd();
                    break;
                }
                posStart = this.variant.getEnd();
                posEnd = this.variant.getStart();
                break;
            }
            case INTERVAL: {
                return "";
            }
            default: {
                throw new RuntimeException("Unimplemented method for variant type " + (Object)((Object)this.variant.getVariantType()));
            }
        }
        if (posStart == posEnd) {
            return this.pos(posStart);
        }
        return this.pos(posStart) + "_" + this.pos(posEnd);
    }

    protected String pos(int pos) {
        if (this.tr == null) {
            return Integer.toString(pos + 1);
        }
        Exon ex = this.tr.findExon(pos);
        if (ex != null) {
            return this.posExon(pos);
        }
        Intron intron = this.tr.findIntron(pos);
        if (intron != null) {
            return this.posIntron(pos, intron);
        }
        if (this.isDownstream(pos)) {
            return this.posDownstream(pos);
        }
        if (this.isUpstream(pos)) {
            return this.posUpstream(pos);
        }
        throw new RuntimeException("Unknown HGVS position");
    }

    protected String posDownstream(int pos) {
        int baseNumCdsEnd = this.tr.getCdsEnd();
        int idx = Math.abs(pos - baseNumCdsEnd);
        return "*" + idx;
    }

    protected String posExon(int pos) {
        if (this.tr.isUtr3(pos)) {
            return this.posUtr3(pos);
        }
        if (this.tr.isUtr5(pos)) {
            return this.posUtr5(pos);
        }
        int idx = this.tr.baseNumberCds(pos, false) + 1;
        if (idx <= 0) {
            return null;
        }
        return "" + idx;
    }

    protected String posIntron(int pos, Intron intron) {
        int distanceRight;
        int posExon = -1;
        String posExonStr = "";
        int distanceLeft = Math.max(0, pos - intron.getStart()) + 1;
        if (distanceLeft < (distanceRight = Math.max(0, intron.getEnd() - pos) + 1)) {
            posExon = intron.getStart() - 1;
            posExonStr = intron.isStrandPlus() ? "+" : "-";
        } else if (distanceRight < distanceLeft) {
            posExon = intron.getEnd() + 1;
            posExonStr = intron.isStrandPlus() ? "-" : "+";
        } else {
            posExonStr = "+";
            posExon = this.strandPlus ? intron.getStart() - 1 : intron.getEnd() + 1;
        }
        int exonDistance = Math.abs(posExon - pos);
        int cdsLeft = Math.min(this.tr.getCdsStart(), this.tr.getCdsEnd());
        int cdsRight = Math.max(this.tr.getCdsStart(), this.tr.getCdsEnd());
        if (posExon >= cdsLeft && posExon <= cdsRight) {
            int distExonBase = this.tr.baseNumberCds(posExon, false) + 1;
            return distExonBase + (exonDistance > 0 ? posExonStr + exonDistance : "");
        }
        int cdnaPos = this.tr.baseNumber2MRnaPos(posExon);
        if (posExon < cdsLeft) {
            int cdnaStart = this.tr.baseNumber2MRnaPos(cdsLeft);
            int utrDistance = Math.abs(cdnaStart - cdnaPos);
            String utrStr = this.strandPlus ? "-" : "*";
            return utrStr + utrDistance + (exonDistance > 0 ? posExonStr + exonDistance : "");
        }
        int cdnaEnd = this.tr.baseNumber2MRnaPos(cdsRight);
        int utrDistance = Math.abs(cdnaEnd - cdnaPos);
        String utrStr = this.strandPlus ? "*" : "-";
        return utrStr + utrDistance + (exonDistance > 0 ? posExonStr + exonDistance : "");
    }

    protected String posUpstream(int pos) {
        int tss = this.tr.getCdsStart();
        int idx = Math.abs(pos - tss);
        if (idx <= 0) {
            return null;
        }
        return "-" + idx;
    }

    protected String posUtr3(int pos) {
        int baseNumCdsEnd;
        int baseNum = this.tr.baseNumber2MRnaPos(pos);
        int idx = Math.abs(baseNum - (baseNumCdsEnd = this.tr.baseNumber2MRnaPos(this.tr.getCdsEnd())));
        if (idx <= 0) {
            return null;
        }
        return "*" + idx;
    }

    protected String posUtr5(int pos) {
        int baseNumTss;
        int baseNum = this.tr.baseNumber2MRnaPos(pos);
        int idx = Math.abs(baseNum - (baseNumTss = this.tr.baseNumber2MRnaPos(this.tr.getCdsStart())));
        if (idx <= 0) {
            return null;
        }
        return "-" + idx;
    }

    public String toString() {
        String pos;
        if (this.variant == null || this.genome == null) {
            return null;
        }
        if (this.variant.isIns()) {
            this.duplication = this.isDuplication();
        }
        if ((pos = this.pos()) == null) {
            return null;
        }
        String type = "";
        switch (this.variant.getVariantType()) {
            case INS: {
                type = this.duplication ? "dup" : "ins";
                break;
            }
            case DEL: {
                type = "del";
                break;
            }
            case MNP: {
                type = "";
                break;
            }
            case SNP: 
            case MIXED: 
            case INTERVAL: {
                type = "";
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented method for variant type " + (Object)((Object)this.variant.getVariantType()));
            }
        }
        return this.codingPrefix() + pos + type + this.dnaBaseChange();
    }
}

