/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import java.util.HashMap;

public enum EffectType {
    CHROMOSOME_LARGE_DELETION,
    EXON_DELETED,
    FRAME_SHIFT,
    STOP_GAINED,
    STOP_LOST,
    START_LOST,
    SPLICE_SITE_ACCEPTOR,
    SPLICE_SITE_DONOR,
    RARE_AMINO_ACID,
    NON_SYNONYMOUS_CODING,
    CODON_INSERTION,
    CODON_CHANGE_PLUS_CODON_INSERTION,
    CODON_DELETION,
    CODON_CHANGE_PLUS_CODON_DELETION,
    UTR_5_DELETED,
    UTR_3_DELETED,
    SPLICE_SITE_BRANCH_U12,
    SPLICE_SITE_REGION,
    SPLICE_SITE_BRANCH,
    NON_SYNONYMOUS_STOP,
    NON_SYNONYMOUS_START,
    SYNONYMOUS_CODING,
    SYNONYMOUS_START,
    SYNONYMOUS_STOP,
    CODON_CHANGE,
    UTR_5_PRIME,
    UTR_3_PRIME,
    START_GAINED,
    UPSTREAM,
    DOWNSTREAM,
    MOTIF,
    REGULATION,
    MICRO_RNA,
    CUSTOM,
    NEXT_PROT,
    INTRON_CONSERVED,
    INTRON,
    INTRAGENIC,
    INTERGENIC_CONSERVED,
    INTERGENIC,
    CDS,
    EXON,
    TRANSCRIPT,
    GENE,
    SEQUENCE,
    CHROMOSOME_ELONGATION,
    CHROMOSOME,
    GENOME,
    NONE;

    static HashMap<String, EffectType> so2efftype;

    public static EffectType parse(EffFormatVersion formatVersion, String str) {
        try {
            return EffectType.valueOf(str);
        }
        catch (Exception exception) {
            if (so2efftype.isEmpty()) {
                EffectType.so2efftype(formatVersion, null);
                EffectType.so2efftype(formatVersion, Variant.NO_VARIANT);
            }
            if (so2efftype.containsKey(str)) {
                return so2efftype.get(str);
            }
            throw new RuntimeException("Cannot parse EffectType '" + str + "'");
        }
    }

    static void so2efftype(EffFormatVersion formatVersion, Variant variant) {
        for (EffectType efftype : EffectType.values()) {
            String so = efftype.toSequenceOntology(formatVersion, variant);
            for (String soSingle : so.split(formatVersion.separatorSplit())) {
                if (so2efftype.containsKey(soSingle)) continue;
                so2efftype.put(soSingle, efftype);
            }
        }
    }

    public VariantEffect.EffectImpact effectImpact() {
        switch (this) {
            case EXON_DELETED: 
            case FRAME_SHIFT: 
            case SPLICE_SITE_ACCEPTOR: 
            case SPLICE_SITE_DONOR: 
            case START_LOST: 
            case STOP_GAINED: 
            case STOP_LOST: 
            case RARE_AMINO_ACID: 
            case CHROMOSOME_LARGE_DELETION: {
                return VariantEffect.EffectImpact.HIGH;
            }
            case CODON_CHANGE_PLUS_CODON_DELETION: 
            case CODON_CHANGE_PLUS_CODON_INSERTION: 
            case CODON_DELETION: 
            case CODON_INSERTION: 
            case NON_SYNONYMOUS_CODING: 
            case SPLICE_SITE_BRANCH_U12: 
            case UTR_3_DELETED: 
            case UTR_5_DELETED: {
                return VariantEffect.EffectImpact.MODERATE;
            }
            case SPLICE_SITE_REGION: 
            case SPLICE_SITE_BRANCH: 
            case NON_SYNONYMOUS_START: 
            case NON_SYNONYMOUS_STOP: 
            case START_GAINED: 
            case SYNONYMOUS_CODING: 
            case SYNONYMOUS_START: 
            case SYNONYMOUS_STOP: 
            case CODON_CHANGE: {
                return VariantEffect.EffectImpact.LOW;
            }
            case CDS: 
            case CHROMOSOME: 
            case CHROMOSOME_ELONGATION: 
            case CUSTOM: 
            case DOWNSTREAM: 
            case EXON: 
            case GENE: 
            case GENOME: 
            case INTRAGENIC: 
            case INTERGENIC: 
            case INTERGENIC_CONSERVED: 
            case INTRON: 
            case INTRON_CONSERVED: 
            case MICRO_RNA: 
            case NONE: 
            case REGULATION: 
            case SEQUENCE: 
            case TRANSCRIPT: 
            case UPSTREAM: 
            case UTR_3_PRIME: 
            case UTR_5_PRIME: {
                return VariantEffect.EffectImpact.MODIFIER;
            }
            case MOTIF: {
                return VariantEffect.EffectImpact.LOW;
            }
            case NEXT_PROT: {
                return VariantEffect.EffectImpact.MODIFIER;
            }
        }
        throw new RuntimeException("Unknown impact for effect type: '" + (Object)((Object)this) + "'");
    }

    public EffectType getGeneRegion() {
        switch (this) {
            case CHROMOSOME_LARGE_DELETION: 
            case CDS: 
            case CHROMOSOME: 
            case CHROMOSOME_ELONGATION: 
            case CUSTOM: 
            case NONE: 
            case SEQUENCE: {
                return NONE;
            }
            case INTERGENIC: 
            case INTERGENIC_CONSERVED: {
                return INTERGENIC;
            }
            case UPSTREAM: {
                return UPSTREAM;
            }
            case UTR_5_DELETED: 
            case START_GAINED: 
            case UTR_5_PRIME: {
                return UTR_5_PRIME;
            }
            case SPLICE_SITE_ACCEPTOR: {
                return SPLICE_SITE_ACCEPTOR;
            }
            case SPLICE_SITE_BRANCH_U12: 
            case SPLICE_SITE_BRANCH: {
                return SPLICE_SITE_BRANCH;
            }
            case SPLICE_SITE_DONOR: {
                return SPLICE_SITE_DONOR;
            }
            case SPLICE_SITE_REGION: {
                return SPLICE_SITE_REGION;
            }
            case START_LOST: 
            case NON_SYNONYMOUS_START: 
            case SYNONYMOUS_START: 
            case GENE: 
            case INTRAGENIC: 
            case TRANSCRIPT: 
            case NEXT_PROT: {
                return TRANSCRIPT;
            }
            case EXON_DELETED: 
            case FRAME_SHIFT: 
            case STOP_GAINED: 
            case STOP_LOST: 
            case RARE_AMINO_ACID: 
            case CODON_CHANGE_PLUS_CODON_DELETION: 
            case CODON_CHANGE_PLUS_CODON_INSERTION: 
            case CODON_DELETION: 
            case CODON_INSERTION: 
            case NON_SYNONYMOUS_CODING: 
            case NON_SYNONYMOUS_STOP: 
            case SYNONYMOUS_CODING: 
            case SYNONYMOUS_STOP: 
            case CODON_CHANGE: 
            case EXON: {
                return EXON;
            }
            case INTRON: 
            case INTRON_CONSERVED: {
                return INTRON;
            }
            case UTR_3_DELETED: 
            case UTR_3_PRIME: {
                return UTR_3_PRIME;
            }
            case DOWNSTREAM: {
                return DOWNSTREAM;
            }
            case REGULATION: {
                return REGULATION;
            }
            case MOTIF: {
                return MOTIF;
            }
            case MICRO_RNA: {
                return MICRO_RNA;
            }
            case GENOME: {
                return GENOME;
            }
        }
        throw new RuntimeException("Unknown gene region for effect type: '" + (Object)((Object)this) + "'");
    }

    public String toSequenceOntology(EffFormatVersion formatVersion, Variant variant) {
        switch (this) {
            case CDS: {
                return "coding_sequence_variant";
            }
            case CHROMOSOME_LARGE_DELETION: {
                return "chromosome_number_variation";
            }
            case CHROMOSOME: {
                return "chromosome";
            }
            case CHROMOSOME_ELONGATION: {
                return "feature_elongation";
            }
            case CODON_CHANGE: {
                return "coding_sequence_variant";
            }
            case CODON_CHANGE_PLUS_CODON_INSERTION: {
                return "disruptive_inframe_insertion";
            }
            case CODON_CHANGE_PLUS_CODON_DELETION: {
                return "disruptive_inframe_deletion";
            }
            case CODON_DELETION: {
                return "inframe_deletion";
            }
            case CODON_INSERTION: {
                return "inframe_insertion";
            }
            case DOWNSTREAM: {
                return "downstream_gene_variant";
            }
            case EXON: {
                if (variant != null && (!variant.isVariant() || variant.isInterval())) {
                    return "exon_region";
                }
                return "non_coding_exon_variant";
            }
            case EXON_DELETED: {
                return "exon_loss_variant";
            }
            case FRAME_SHIFT: {
                return "frameshift_variant";
            }
            case GENE: {
                return "gene_variant";
            }
            case INTERGENIC: {
                return "intergenic_region";
            }
            case INTERGENIC_CONSERVED: {
                return "conserved_intergenic_variant";
            }
            case INTRON: {
                return "intron_variant";
            }
            case INTRON_CONSERVED: {
                return "conserved_intron_variant";
            }
            case INTRAGENIC: {
                return "intragenic_variant";
            }
            case MICRO_RNA: {
                return "miRNA";
            }
            case MOTIF: {
                return "TF_binding_site_variant";
            }
            case NEXT_PROT: {
                return "sequence_feature";
            }
            case NON_SYNONYMOUS_CODING: {
                return "missense_variant";
            }
            case NON_SYNONYMOUS_START: {
                return "initiator_codon_variant";
            }
            case NON_SYNONYMOUS_STOP: {
                return "stop_retained_variant";
            }
            case RARE_AMINO_ACID: {
                return "rare_amino_acid_variant";
            }
            case REGULATION: {
                return "regulatory_region_variant";
            }
            case SPLICE_SITE_ACCEPTOR: {
                return "splice_acceptor_variant";
            }
            case SPLICE_SITE_DONOR: {
                return "splice_donor_variant";
            }
            case SPLICE_SITE_REGION: {
                return "splice_region_variant";
            }
            case SPLICE_SITE_BRANCH: {
                return "splice_branch_variant";
            }
            case SPLICE_SITE_BRANCH_U12: {
                return "splice_branch_variant";
            }
            case START_LOST: {
                return "start_lost";
            }
            case START_GAINED: {
                return "5_prime_UTR_premature_start_codon_gain_variant";
            }
            case STOP_GAINED: {
                return "stop_gained";
            }
            case STOP_LOST: {
                return "stop_lost";
            }
            case SYNONYMOUS_CODING: {
                return "synonymous_variant";
            }
            case SYNONYMOUS_STOP: {
                return "stop_retained_variant";
            }
            case SYNONYMOUS_START: {
                return "initiator_codon_variant" + formatVersion.separator() + "non_canonical_start_codon";
            }
            case TRANSCRIPT: {
                return "non_coding_transcript_variant";
            }
            case UPSTREAM: {
                return "upstream_gene_variant";
            }
            case UTR_3_PRIME: {
                return "3_prime_UTR_variant";
            }
            case UTR_3_DELETED: {
                return "3_prime_UTR_truncation" + formatVersion.separator() + "exon_loss_variant";
            }
            case UTR_5_PRIME: {
                return "5_prime_UTR_variant";
            }
            case UTR_5_DELETED: {
                return "5_prime_UTR_truncation" + formatVersion.separator() + "exon_loss_variant";
            }
            case CUSTOM: {
                return "custom";
            }
            case GENOME: 
            case NONE: 
            case SEQUENCE: {
                return "";
            }
        }
        throw new RuntimeException("Unknown SO term for " + this.toString());
    }

    static {
        so2efftype = new HashMap();
    }
}

