/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

public class RankSumNoReplacementSimulate {
    int n;
    int numberOfSamples;
    long[][] rankSum;
    int[][] samples;

    public static void main(String[] args) {
        System.out.println("Begin: RankSumNoReplacementSimulate");
        int numberOfSamples = 100000;
        int n = 2;
        while (true) {
            RankSumNoReplacementSimulate rss = new RankSumNoReplacementSimulate(numberOfSamples, n);
            for (int nt = 1; nt <= rss.n; ++nt) {
                double mu = rss.mean(nt);
                double muSample = rss.sampleMean(nt);
                double muErr = mu != 0.0 ? Math.abs(mu - muSample) / mu : 0.0;
                double sigmaSample = Math.sqrt(rss.sampleVariance(nt));
                double sigma = Math.sqrt(rss.variance(nt));
                double simgaErr = sigma != 0.0 ? Math.abs(sigma - sigmaSample) / sigma : 0.0;
                System.out.println("N:" + n + "\tNT:" + nt + "\tmu:" + mu + "\tmuSample:" + muSample + "\terr%:" + muErr + "\t|\tsigma:" + sigma + "\tsigmaSample:" + sigmaSample + "\terr%:" + simgaErr);
            }
            ++n;
        }
    }

    public RankSumNoReplacementSimulate(int numberOfSamples, int n) {
        this.numberOfSamples = numberOfSamples;
        this.n = n;
        this.samples = new int[numberOfSamples][n];
        this.rankSum = new long[numberOfSamples][n];
        this.initSamples();
        this.randomizeSamples();
        this.rankSum();
    }

    public int getN() {
        return this.n;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public long[][] getRankSum() {
        return this.rankSum;
    }

    public int[][] getSamples() {
        return this.samples;
    }

    public void initSamples() {
        for (int ns = 0; ns < this.numberOfSamples; ++ns) {
            for (int i = 0; i < this.n; ++i) {
                this.samples[ns][i] = i + 1;
                this.rankSum[ns][i] = 0L;
            }
        }
    }

    public double mean(int nt) {
        double mean = (double)(nt * (this.n + 1)) / 2.0;
        return mean;
    }

    public void randomizeSamples() {
        for (int ns = 0; ns < this.numberOfSamples; ++ns) {
            int i = 0;
            while (i < this.n) {
                int r1 = i++;
                int r2 = (int)(Math.random() * (double)this.n);
                int tmp = this.samples[ns][r1];
                this.samples[ns][r1] = this.samples[ns][r2];
                this.samples[ns][r2] = tmp;
            }
        }
    }

    public void rankSum() {
        for (int ns = 0; ns < this.numberOfSamples; ++ns) {
            long rs = 0L;
            for (int i = 0; i < this.n; ++i) {
                this.rankSum[ns][i] = rs += (long)this.samples[ns][i];
            }
        }
    }

    public double sampleMean(int nt) {
        if (nt < 1 || nt > this.n) {
            return 0.0;
        }
        double mean = 0.0;
        for (int ns = 0; ns < this.numberOfSamples; ++ns) {
            mean += (double)this.rankSum[ns][nt - 1];
        }
        return mean /= (double)this.numberOfSamples;
    }

    public double sampleVariance(int nt) {
        if (nt < 1 || nt > this.n) {
            return 0.0;
        }
        double mean = this.mean(nt);
        double sum2 = 0.0;
        for (int ns = 0; ns < this.numberOfSamples; ++ns) {
            double d = (double)this.rankSum[ns][nt - 1] - mean;
            sum2 += d * d;
        }
        double var = sum2 / (double)(this.numberOfSamples - 1);
        return var;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setNumberOfSamples(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public void setRankSum(long[][] rankSum) {
        this.rankSum = rankSum;
    }

    public void setSamples(int[][] samples) {
        this.samples = samples;
    }

    public String toString() {
        int i;
        int ns;
        StringBuffer sb = new StringBuffer();
        sb.append("numberOfSamples:" + this.numberOfSamples + "\tN:" + this.n + "\nSamples:\n");
        for (ns = 0; ns < this.numberOfSamples; ++ns) {
            sb.append(ns + ":\t");
            for (i = 0; i < this.n; ++i) {
                sb.append(this.samples[ns][i] + " ");
            }
            sb.append("\n");
        }
        sb.append("\nRankSums:\n");
        for (ns = 0; ns < this.numberOfSamples; ++ns) {
            sb.append(ns + ":\t");
            for (i = 0; i < this.n; ++i) {
                sb.append(this.rankSum[ns][i] + " ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public double variance(int nt) {
        double var = 0.0;
        double dnt = nt;
        double dn = this.n;
        double mu = this.mean(nt);
        for (int i = 1; i <= this.n; ++i) {
            for (int j = 1; j <= this.n; ++j) {
                double di = i;
                double dj = j;
                if (i == j) {
                    var += di * dj * dnt / dn;
                    continue;
                }
                var += di * dj * dnt * (dnt - 1.0) / (dn * (dn - 1.0));
            }
        }
        return var -= mu * mu;
    }
}

