/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.ped.Sex;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class TfamEntry
implements Comparable<TfamEntry> {
    public static final int PHENOTYPE_CASE = 2;
    public static final int PHENOTYPE_CONTROL = 1;
    public static final int PHENOTYPE_MISSING = -9;
    String familyId;
    String id;
    String fatherId;
    String motherId;
    Sex sex;
    double phenotype;

    public TfamEntry(String line) {
        this.parse(line);
    }

    public TfamEntry(String familyId, String id, String fatherId, String motherId, Sex sex, double phenotype) {
        this.familyId = familyId;
        this.id = id;
        this.fatherId = fatherId;
        this.motherId = motherId;
        this.sex = sex;
        this.phenotype = phenotype;
    }

    @Override
    public int compareTo(TfamEntry ind) {
        return this.id.compareTo(ind.getId());
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public String getId() {
        return this.id;
    }

    public String getMotherId() {
        return this.motherId;
    }

    public double getPhenotype() {
        return this.phenotype;
    }

    public Sex getSex() {
        return this.sex;
    }

    public boolean isCase() {
        return this.phenotype == 2.0;
    }

    public boolean isControl() {
        return this.phenotype == 1.0;
    }

    public boolean isMissing() {
        return this.phenotype == -9.0;
    }

    protected void parse(String line) {
        String[] fields = line.split("\\s", 7);
        this.parse(fields);
    }

    protected int parse(String[] fields) {
        int fieldNum = 0;
        this.familyId = fields[fieldNum++];
        this.id = fields[fieldNum++];
        this.fatherId = fields[fieldNum++];
        this.motherId = fields[fieldNum++];
        if (this.fatherId.equals("0") || this.fatherId.equals("NA")) {
            this.fatherId = null;
        }
        if (this.motherId.equals("0") || this.motherId.equals("NA")) {
            this.motherId = null;
        }
        int sexnum = Gpr.parseIntSafe(fields[fieldNum++]);
        this.sex = Sex.Unknown;
        if (sexnum == 1) {
            this.sex = Sex.Male;
        } else if (sexnum == 2) {
            this.sex = Sex.Female;
        }
        String phenotypeStr = fields[fieldNum++];
        this.phenotype = phenotypeStr.equals("0") || phenotypeStr.equals("-9") ? -9.0 : Gpr.parseDoubleSafe(phenotypeStr);
        return fieldNum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sexStr = this.sex == Sex.Male ? "1" : (this.sex == Sex.Female ? "2" : "0");
        sb.append(this.familyId + "\t");
        sb.append(this.id + "\t");
        sb.append(this.fatherId + "\t");
        sb.append(this.motherId + "\t");
        sb.append(sexStr + "\t");
        sb.append(this.phenotype);
        return sb.toString();
    }
}

