/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.ped.PedEntry;
import ca.mcgill.mcb.pcingola.ped.PedFileIterator;
import ca.mcgill.mcb.pcingola.ped.PlinkMap;
import ca.mcgill.mcb.pcingola.ped.TfamEntry;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PedPedigree
implements Iterable<TfamEntry>,
Comparable<PedPedigree> {
    boolean verbose = false;
    HashMap<String, TfamEntry> tfamEntryById = new HashMap();
    List<TfamEntry> tfamEntries = new ArrayList<TfamEntry>();
    PlinkMap plinkMap;

    public PedPedigree() {
    }

    public PedPedigree(String tfamFileName) {
        this.loadTfam(tfamFileName);
    }

    public void add(TfamEntry tfamEntry) {
        this.tfamEntryById.put(tfamEntry.getId(), tfamEntry);
        this.tfamEntries.add(tfamEntry);
    }

    @Override
    public int compareTo(PedPedigree ped) {
        return this.getFamilyId().compareTo(ped.getFamilyId());
    }

    public Collection<PedPedigree> families() {
        AutoHashMap<String, PedPedigree> families = new AutoHashMap<String, PedPedigree>(new PedPedigree());
        for (TfamEntry ind : this) {
            String fid = ind.getFamilyId();
            PedPedigree ped = families.getOrCreate(fid);
            ped.add(ind);
        }
        return families.values();
    }

    public TfamEntry get(String id) {
        return this.tfamEntryById.get(id);
    }

    public String getFamilyId() {
        if (this.tfamEntries.isEmpty()) {
            return "";
        }
        return this.tfamEntries.get(0).getFamilyId();
    }

    public PlinkMap getPlinkMap() {
        return this.plinkMap;
    }

    public List<String> getSampleIds() {
        ArrayList<String> sampleIds = new ArrayList<String>();
        for (TfamEntry te : this.tfamEntries) {
            sampleIds.add(te.id);
        }
        return sampleIds;
    }

    @Override
    public Iterator<TfamEntry> iterator() {
        return this.tfamEntries.iterator();
    }

    public Set<String> keySet() {
        return this.tfamEntryById.keySet();
    }

    public void load(String pedFileName) {
        String pedBaseFileName = Gpr.removeExt(pedFileName);
        String mapFile = pedBaseFileName + ".map";
        PedFileIterator pedFile = new PedFileIterator(pedFileName, mapFile);
        int count2 = 1;
        for (PedEntry pe : pedFile) {
            if (this.verbose) {
                Gpr.showMarkStderr(count2++, 1);
            }
            this.add(pe);
        }
        this.plinkMap = pedFile.getPlinkMap();
    }

    public void loadTfam(String tfamFileName) {
        String tfamStr = Gpr.readFile(tfamFileName);
        if (tfamStr.isEmpty()) {
            throw new RuntimeException("Cannot read file '" + tfamFileName + "'");
        }
        for (String line : tfamStr.split("\n")) {
            if (line.startsWith("#")) continue;
            try {
                TfamEntry te = new TfamEntry(line);
                this.add(te);
            }
            catch (Throwable t2) {
                throw new RuntimeException("Error parsing line from PED/TFAM file:\n\tFile name : '" + tfamFileName + "\n\tLine: '" + line + "'", t2);
            }
        }
    }

    public void saveTfam(String fileName) {
        StringBuilder sb = new StringBuilder();
        for (TfamEntry te : this) {
            sb.append(te + "\n");
        }
        Gpr.toFile(fileName, sb.toString());
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int size() {
        return this.tfamEntryById.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TfamEntry te : this) {
            sb.append(te.toString() + "\n");
        }
        return sb.toString();
    }

    public Collection<TfamEntry> values() {
        return this.tfamEntryById.values();
    }
}

