/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.outputFormatter.BedOutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import java.util.HashSet;

public class BedAnnotationOutputFormatter
extends BedOutputFormatter {
    public BedAnnotationOutputFormatter() {
        this.outOffset = 0;
    }

    @Override
    public String toString() {
        Variant seqChange = (Variant)this.section;
        String variantName = seqChange.getChromosomeName() + ":" + (seqChange.getStart() + this.outOffset);
        HashSet<String> chEffs = new HashSet<String>();
        for (VariantEffect changeEffect : this.variantEffects) {
            if (this.variantEffectResutFilter != null && this.variantEffectResutFilter.filter(changeEffect)) continue;
            String ann = null;
            Marker m = changeEffect.getMarker();
            if (m != null) {
                String geneName = null;
                Gene gene = changeEffect.getGene();
                if (gene != null) {
                    geneName = this.useGeneId ? gene.getId() : gene.getGeneName();
                }
                String type = m.getType().toString();
                if (m instanceof Regulation) {
                    Regulation r = (Regulation)m;
                    type = type + "|" + r.getName() + "|" + r.getCellType();
                }
                ann = m.getChromosomeName() + "\t" + "\t" + (m.getStart() + this.outOffset) + "\t" + (m.getEnd() + this.outOffset + 1) + "\t" + variantName + ";" + type + (geneName != null ? ":" + geneName : "");
            }
            if (ann == null) continue;
            chEffs.add(ann);
        }
        StringBuilder sb = new StringBuilder();
        for (String chEff : chEffs) {
            sb.append(chEff + "\n");
        }
        return sb.toString();
    }

    @Override
    public String toStringHeader() {
        return "# SnpEff version " + this.version + "\n" + "# Command line: " + this.commandLineStr + "\n" + "# Chromo\tStart\tEnd\tVariant;Annotation\tScore";
    }
}

