/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.osCmd;

import ca.mcgill.mcb.pcingola.osCmd.OsCmdRunner;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class OsCmdQueue
implements Iterable<OsCmdRunner> {
    public static boolean debug = false;
    ArrayList<OsCmdRunner> commands;
    ArrayList<OsCmdRunner> commandsToRun;
    HashSet<OsCmdRunner> commandsDone;
    HashSet<OsCmdRunner> commandsRunning;
    HashMap<OsCmdRunner, String> outputFiles;
    boolean verbose = false;
    boolean throwExceptionOnError = false;
    boolean redirectToOutput = true;
    int numThreads = Gpr.NUM_CORES;
    int sleepTime = 1000;

    public OsCmdQueue() {
        this.commands = new ArrayList();
        this.outputFiles = new HashMap();
    }

    public void add(OsCmdRunner cmd) {
        this.commands.add(cmd);
    }

    public void add(OsCmdRunner cmd, String outputFile) {
        this.commands.add(cmd);
        this.outputFiles.put(cmd, outputFile);
    }

    void doneCommands() {
        if (this.commandsRunning.isEmpty()) {
            return;
        }
        LinkedList<OsCmdRunner> toDelete = new LinkedList<OsCmdRunner>();
        for (OsCmdRunner cmd : this.commandsRunning) {
            if (!cmd.isDone()) continue;
            toDelete.add(cmd);
            if (cmd.getExitValue() <= 0) continue;
            String message = "Error executing command: Command: " + cmd + "\n" + "\n---------- STDOUT: Start ----------\n" + cmd.getStdout() + "\n---------- STDOUT: End ----------\n" + "\n---------- STDERR: Start ----------\n" + cmd.getStderr() + "\n---------- STDERR: End ----------\n";
            if (this.throwExceptionOnError) {
                throw new RuntimeException(message);
            }
            System.err.println(message);
        }
        for (OsCmdRunner cmd : toDelete) {
            if (this.verbose) {
                Timer.showStdErr("Finished command: " + cmd);
            }
            this.commandsRunning.remove(cmd);
            this.commandsDone.add(cmd);
        }
    }

    @Override
    public Iterator<OsCmdRunner> iterator() {
        return this.commands.iterator();
    }

    public void kill() {
        for (OsCmdRunner cmd : this.commands) {
            Gpr.debug("Queue failed. Killing command: " + cmd);
            cmd.finish();
        }
    }

    public void run() {
        if (this.verbose) {
            Timer.showStdErr("Starting " + this);
        }
        if (this.commandsDone != null) {
            throw new RuntimeException("Cannot re-run a queue! Please create a new one.");
        }
        try {
            this.commandsToRun = new ArrayList();
            this.commandsToRun.addAll(this.commands);
            this.commandsDone = new HashSet();
            this.commandsRunning = new HashSet();
            while (!this.commandsToRun.isEmpty() || !this.commandsRunning.isEmpty()) {
                if (this.commandsRunning.size() < this.numThreads && !this.commandsToRun.isEmpty()) {
                    OsCmdRunner cmdNext = this.commandsToRun.remove(0);
                    this.run(cmdNext);
                }
                this.doneCommands();
                this.sleep();
                if (!debug) continue;
                Timer.showStdErr("Queue processes:\tPending : " + this.commandsToRun.size() + "\tRunning: " + this.commandsRunning.size() + "\tDone: " + this.commandsDone.size());
            }
        }
        catch (Throwable t2) {
            this.kill();
            throw new RuntimeException("Queue aborted due to exception.", t2);
        }
    }

    void run(OsCmdRunner cmd) {
        String outputFile = this.outputFiles.get(cmd);
        if (this.verbose) {
            Timer.showStdErr("Running command: '" + cmd + "'");
        }
        if (outputFile == null) {
            this.commandsRunning.add(cmd);
            cmd.start();
        } else if (!Gpr.exists(outputFile)) {
            this.commandsRunning.add(cmd);
            if (this.redirectToOutput) {
                cmd.getOsCmd().setBinaryStdout(true);
                cmd.getOsCmd().setRedirectStdout(outputFile);
            }
            cmd.start();
        } else {
            this.commandsDone.add(cmd);
        }
    }

    void runCommands() {
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setRedirectToOutput(boolean redirectToOutput) {
        this.redirectToOutput = redirectToOutput;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int size() {
        return this.commands.size();
    }

    void sleep() {
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int done = 0;
        int executing = 0;
        for (OsCmdRunner cmd : this.commands) {
            if (cmd.isDone()) {
                ++done;
            }
            if (!cmd.isExecuting()) continue;
            ++executing;
        }
        sb.append("Queue:\n");
        sb.append("\tSize       : " + this.commands.size() + "\n");
        sb.append("\tExecuting  : " + executing + "\n");
        sb.append("\tDone       : " + done + "\n");
        sb.append("\tCPUs       : " + this.numThreads + "\n");
        sb.append("\tSleep time : " + this.sleepTime + "\n");
        for (OsCmdRunner cmd : this.commands) {
            String status = "Not started";
            if (cmd.isDone()) {
                status = "Done";
            } else if (cmd.isExecuting()) {
                status = "Executing";
            }
            sb.append(String.format("\t[%12s]\t%s\n", status, cmd));
        }
        return sb.toString();
    }
}

