/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.motif;

import ca.mcgill.mcb.pcingola.util.Gpr;

public class Pwm {
    public static final int SCALE = 100;
    static final double LOG2 = Math.log(2.0);
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    int[][] countMatrix;
    int[] count;
    double[][] logOdds;
    int length;
    int totalCount;
    String name;
    String id;
    char[] bestSequence;

    public Pwm(int length) {
        this.length = length;
        this.countMatrix = new int[BASES.length][length];
        this.count = new int[BASES.length];
        this.logOdds = null;
    }

    public Pwm(String file) {
        String data2 = Gpr.readFile(file);
        String[] lines2 = data2.split("\n");
        this.length = lines2.length;
        this.countMatrix = new int[BASES.length][this.length];
        this.count = new int[BASES.length];
        this.logOdds = new double[BASES.length][this.length];
        for (int lineNum = 0; lineNum < lines2.length; ++lineNum) {
            String[] val = lines2[lineNum].trim().split("\\s+");
            for (int baseNum = 0; baseNum < BASES.length; ++baseNum) {
                this.logOdds[baseNum][lineNum] = Gpr.parseDoubleSafe(val[baseNum]);
            }
        }
    }

    int base2int(char base) {
        switch (base) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 3;
            }
        }
        return -1;
    }

    public void calcLogOddsWeight() {
        int baseNum;
        this.logOdds = new double[BASES.length][this.length];
        double[] b = new double[BASES.length];
        int total = 0;
        for (baseNum = 0; baseNum < BASES.length; ++baseNum) {
            this.count[baseNum] = 0;
            for (int i = 0; i < this.length; ++i) {
                int n = baseNum;
                this.count[n] = this.count[n] + this.countMatrix[baseNum][i];
                total += this.countMatrix[baseNum][i];
            }
        }
        for (baseNum = 0; baseNum < BASES.length; ++baseNum) {
            b[baseNum] = (double)(this.count[baseNum] + 1) / (double)total;
        }
        for (int i = 0; i < this.length; ++i) {
            for (int baseNum2 = 0; baseNum2 < BASES.length; ++baseNum2) {
                double p = (double)(this.countMatrix[baseNum2][i] + 1) / (double)total;
                this.logOdds[baseNum2][i] = -p * Math.log(p / b[baseNum2]) / LOG2;
            }
        }
    }

    public char[] getBestSequence() {
        if (this.bestSequence == null) {
            this.bestSequence = new char[this.length];
            for (int i = 0; i < this.countMatrix[0].length; ++i) {
                int max2 = 0;
                int maxb = 0;
                for (int b = 0; b < BASES.length; ++b) {
                    if (max2 >= this.countMatrix[b][i]) continue;
                    max2 = this.countMatrix[b][i];
                    maxb = b;
                }
                this.bestSequence[i] = BASES[maxb];
            }
        }
        return this.bestSequence;
    }

    public String getBestSequenceStr() {
        return new String(this.getBestSequence());
    }

    public int getCount(char base, int position) {
        return this.countMatrix[this.base2int(base)][position];
    }

    public String getId() {
        return this.id;
    }

    public double getLogOdds(char base, int position) {
        int baseIdx = this.base2int(base);
        if (baseIdx < 0 || position >= this.size()) {
            return 0.0;
        }
        return this.logOdds[baseIdx][position];
    }

    public String getName() {
        return this.name;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean isConserved(int pos) {
        int countNonZero = 0;
        for (int i = 0; i < this.countMatrix.length; ++i) {
            if (this.countMatrix[i][pos] <= 0) continue;
            ++countNonZero;
        }
        return countNonZero == 1;
    }

    public int length() {
        return this.length;
    }

    public double score(String dna) {
        if (this.logOdds == null) {
            this.calcLogOddsWeight();
        }
        char[] bases = dna.toCharArray();
        double score = 0.0;
        for (int i = 0; i < bases.length; ++i) {
            score += this.getLogOdds(bases[i], i);
        }
        return score / (double)this.length;
    }

    public void set(String dna) {
        char[] bases = dna.toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            for (int j = 0; j < BASES.length; ++j) {
                this.countMatrix[j][i] = 1;
            }
            this.countMatrix[this.base2int((char)bases[i])][i] = 100;
        }
    }

    public void setCounts(char base, int[] counts) {
        int rowIdx = this.base2int(base);
        for (int i = 0; i < counts.length; ++i) {
            this.countMatrix[rowIdx][i] = counts[i];
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    int size() {
        return this.countMatrix[0].length;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Name: " + this.name + "\tId: " + this.id + "\n");
        if (this.countMatrix != null) {
            sb.append("Counts:\n");
            for (int b = 0; b < BASES.length; ++b) {
                sb.append(BASES[b] + "\t");
                for (i = 0; i < this.countMatrix[b].length; ++i) {
                    sb.append(String.format("%10d  ", this.countMatrix[b][i]));
                }
                sb.append("\n");
            }
            sb.append("Max:\t");
            char[] best = this.getBestSequence();
            for (i = 0; i < this.countMatrix[0].length; ++i) {
                sb.append(String.format("%10s  ", Character.valueOf(best[i])));
            }
            sb.append("\n");
        }
        if (this.logOdds != null) {
            sb.append("\nWeights:\n");
            for (int b = 0; b < BASES.length; ++b) {
                sb.append(BASES[b] + "\t");
                for (i = 0; i < this.logOdds[b].length; ++i) {
                    sb.append(String.format("%10.2f  ", this.logOdds[b][i]));
                }
                sb.append("\n");
            }
            sb.append("Max:\t");
            for (int i2 = 0; i2 < this.countMatrix[0].length; ++i2) {
                int maxb = 0;
                double max2 = Double.NEGATIVE_INFINITY;
                for (int b = 0; b < BASES.length; ++b) {
                    if (!(max2 < this.logOdds[b][i2])) continue;
                    max2 = this.logOdds[b][i2];
                    maxb = b;
                }
                sb.append(String.format("%10s  ", Character.valueOf(BASES[maxb])));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void updateCounts(String dna) {
        this.updateCounts(dna, 1);
    }

    public void updateCounts(String dna, int inc) {
        this.totalCount += inc;
        char[] bases = dna.toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            int code = this.base2int(bases[i]);
            if (code < 0) continue;
            int[] nArray = this.countMatrix[code];
            int n = i;
            nArray[n] = nArray[n] + inc;
        }
    }
}

