/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.logStatsServer;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class LogStats
extends Thread {
    public static final int LOG_THREAD_WAIT_TIME = 1000;
    public static final int LOG_THREAD_WAIT_TIME_REPEAT = 5;
    public static boolean debug = false;
    private static final String URL_WWW = "http://www.tacner.com/";
    private static final String URL_ROOT = "http://www.tacner.com/special/recuse.php";
    private static final String HTTP_CHARSET = "ISO-8859-1";
    private static final int HTTP_CONNECT_TIMEOUT_MSECS = 22000;
    private static final int HTTP_READ_TIMEOUT_MSECS = 23000;
    public StringBuilder msg = new StringBuilder();
    private final String versionFull;
    private RequestResult res = RequestResult.NOINFO;
    private long duration;
    protected boolean log = true;
    protected boolean verbose = false;
    HashMap<String, String> values;

    public static LogStats report(String software, String versionShort, String versionFull, boolean ok, boolean verbose, String[] args, String errorMessage, HashMap<String, String> reportValues) {
        String[] properties;
        LogStats logStats = new LogStats(software, versionShort, versionFull);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                logStats.add("args_" + i, args[i]);
            }
        }
        logStats.add("Finished_OK", Boolean.toString(ok));
        if (errorMessage != null && !errorMessage.isEmpty()) {
            logStats.add("Error", errorMessage);
        }
        for (String prop : properties = new String[]{"user.name", "os.name", "os.version", "os.arch"}) {
            try {
                logStats.add(prop, System.getProperty(prop));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            logStats.add("num.cores", Gpr.NUM_CORES + "");
            logStats.add("total.mem", Runtime.getRuntime().totalMemory() + "");
        }
        catch (Exception e) {
            // empty catch block
        }
        for (String name : reportValues.keySet()) {
            logStats.add(name, reportValues.get(name));
        }
        logStats.start();
        if (verbose) {
            Timer.showStdErr("Logging");
        }
        for (int i = 0; i < 5 && logStats.isAlive(); ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (logStats.isAlive() && !logStats.isInterrupted()) {
            logStats.interrupt();
        }
        return logStats;
    }

    public LogStats(String software, String versionShort, String versionFull) {
        this.versionFull = versionFull;
        this.values = new HashMap();
    }

    public void add(String name, String value2) {
        value2 = value2.replaceAll("\\n", "\\\\n");
        value2 = value2.replaceAll("\\t", "\\\\t");
        value2 = value2.replaceAll("\\r", "");
        this.values.put(name, value2);
    }

    private URL buildUrl() {
        try {
            return this.buildUrl0();
        }
        catch (MalformedURLException e) {
            this.msg.append(e.getMessage());
            return null;
        }
    }

    private URL buildUrl0() throws MalformedURLException {
        StringBuilder urlsb = new StringBuilder();
        urlsb.append(URL_ROOT).append("?");
        urlsb.append("program=").append(this.encode2url(SnpEff.class.getSimpleName()));
        urlsb.append("&version=").append(this.encode2url(this.versionFull));
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.values.keySet());
        Collections.sort(names);
        for (String name : names) {
            urlsb.append("&" + name + "=").append(this.encode2url(this.values.get(name)));
        }
        return new URL(urlsb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        int step2 = 0;
        long t0 = System.currentTimeMillis();
        if (debug) {
            Gpr.debug("Connect Step = " + step2);
        }
        try {
            URL url = this.buildUrl();
            step2 = 1;
            if (debug) {
                Gpr.debug("Connect Step = " + step2);
            }
            URLConnection httpConnection = url.openConnection();
            step2 = 2;
            if (debug) {
                Gpr.debug("Connect Step = " + step2);
            }
            httpConnection.setConnectTimeout(22000);
            httpConnection.setReadTimeout(23000);
            step2 = 3;
            if (debug) {
                Gpr.debug("Connect Step = " + step2);
            }
            this.res = RequestResult.OK;
        }
        catch (Exception e) {
            this.msg.append(step2 > 3 ? "Bad response" : "Error in connection. ").append(" Step " + step2).append("(").append(e.toString()).append(")");
            this.res = RequestResult.ERROR;
        }
        finally {
            this.duration = System.currentTimeMillis() - t0;
            if (debug && !this.res.completed()) {
                Gpr.debug("Error in connection: " + (Object)((Object)this.res) + " step=" + step2 + " duration(msecs)=" + this.duration + " " + this.msg);
            }
        }
        if (debug) {
            Gpr.debug("Connect done!");
        }
    }

    private String encode2url(String data2) {
        try {
            return URLEncoder.encode(data2, HTTP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public RequestResult getRes() {
        return this.res;
    }

    @Override
    public void run() {
        block4: {
            try {
                if (debug) {
                    Gpr.debug("Running thread");
                }
                this.connect();
                if (debug) {
                    Gpr.debug("Thread finished");
                }
            }
            catch (Throwable t2) {
                if (!debug) break block4;
                t2.printStackTrace();
            }
        }
    }

    public static enum RequestResult {
        OK,
        ERROR,
        NOINFO;


        public boolean completed() {
            return this != ERROR && this != NOINFO;
        }
    }
}

