/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;

public class CodonChangeSnp
extends CodonChange {
    public CodonChangeSnp(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.returnNow = true;
    }

    @Override
    protected boolean codonChangeSingle(Exon exon) {
        this.codonsRef = this.codonsRef();
        this.codonsAlt = this.codonsAlt();
        this.effect(exon, EffectType.CODON_CHANGE, "", this.codonsRef, this.codonsAlt, this.codonStartNum, this.codonStartIndex, true);
        if (this.codonsRef.isEmpty()) {
            this.variantEffects.addErrorWarning(this.variant, VariantEffect.ErrorWarningType.ERROR_MISSING_CDS_SEQUENCE);
        }
        return true;
    }

    @Override
    public String codonsAlt() {
        if (this.codonsRef.isEmpty()) {
            return "";
        }
        char[] codonChars = this.codonsRef.toLowerCase().toCharArray();
        char snpBase = this.variant.netChange(this.transcript.isStrandMinus()).charAt(0);
        if (this.codonStartIndex < codonChars.length) {
            codonChars[this.codonStartIndex] = Character.toUpperCase(snpBase);
        }
        String codonsNew = new String(codonChars);
        return codonsNew;
    }

    @Override
    public String codonsRef() {
        int maxBase;
        int numCodons = 1;
        String cdsStr = this.transcript.cds();
        int cdsLen = cdsStr.length();
        int minBase = this.codonStartNum * 3;
        if (minBase < 0) {
            minBase = 0;
        }
        if ((maxBase = this.codonStartNum * 3 + numCodons * 3) > cdsLen) {
            maxBase = cdsLen;
        }
        if (cdsStr.isEmpty() || cdsLen <= minBase) {
            return "";
        }
        char[] codonChars = cdsStr.substring(minBase, maxBase).toLowerCase().toCharArray();
        if (this.codonStartIndex < codonChars.length) {
            codonChars[this.codonStartIndex] = Character.toUpperCase(codonChars[this.codonStartIndex]);
        }
        String codon = new String(codonChars);
        return codon;
    }
}

