/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;

public class CodonChangeDel
extends CodonChange {
    int oldCodonCdsStart = -1;
    int oldCodonCdsEnd = -1;

    public CodonChangeDel(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.returnNow = false;
        this.requireNetCdsChange = true;
    }

    @Override
    protected boolean codonChangeSingle(Exon exon) {
        if (this.netCdsChange.isEmpty()) {
            return false;
        }
        EffectType effType = null;
        if (this.variant.includes(exon)) {
            this.codonsRef = "";
            this.codonsAlt = "";
            this.codonStartIndex = -1;
            this.codonStartNum = -1;
            effType = EffectType.EXON_DELETED;
        } else if (this.netCdsChange.length() % 3 != 0) {
            this.codonsRef = this.codonsRef();
            this.codonsAlt = "";
            effType = EffectType.FRAME_SHIFT;
        } else if (this.codonStartIndex == 0) {
            this.codonsRef = this.codonsRef();
            this.codonsAlt = "";
            effType = EffectType.CODON_DELETION;
        } else {
            this.codonsRef = this.codonsRef();
            this.codonsAlt = this.codonsAlt();
            effType = this.codonsAlt.isEmpty() || this.codonsRef.startsWith(this.codonsAlt) ? EffectType.CODON_DELETION : EffectType.CODON_CHANGE_PLUS_CODON_DELETION;
        }
        this.effect(exon, effType, "", this.codonsRef, this.codonsAlt, this.codonStartNum, this.codonStartIndex, false);
        return true;
    }

    @Override
    public String codonsAlt() {
        if (this.netCdsChange.isEmpty()) {
            return "";
        }
        int after = this.netCdsChange.length() + this.codonStartIndex;
        String prefix = this.codonsRef.length() >= this.codonStartIndex ? this.codonsRef.substring(0, this.codonStartIndex) : this.codonsRef;
        String suffix = this.codonsRef.length() > after ? this.codonsRef.substring(after) : "";
        String codonsAlt = prefix + suffix;
        return codonsAlt;
    }

    @Override
    public String codonsRef() {
        if (this.netCdsChange.isEmpty()) {
            return "";
        }
        int min2 = this.variant.getStart();
        int max2 = this.variant.getEnd();
        int cdsBaseMin = this.cdsBaseNumber(min2);
        int cdsBaseMax = this.cdsBaseNumber(max2);
        if (this.transcript.isStrandMinus()) {
            int swap = cdsBaseMin;
            cdsBaseMin = cdsBaseMax;
            cdsBaseMax = swap;
        }
        if (cdsBaseMax < cdsBaseMin) {
            throw new RuntimeException("This should never happen!\n\tcdsBaseMin: " + cdsBaseMin + "\n\tcdsBaseMax: " + cdsBaseMax + "\n\tmin: " + min2 + "\n\tmax: " + max2 + "\n\tSeqChange: " + this.variant + "\n\ttranscript: " + this.transcript + "\n\tCDS.len: " + this.transcript.cds().length());
        }
        int maxCodon = cdsBaseMax / 3;
        int minCodon = cdsBaseMin / 3;
        this.oldCodonCdsStart = 3 * minCodon;
        this.oldCodonCdsEnd = 3 * (maxCodon + 1) - 1;
        String codons = "";
        codons = this.oldCodonCdsEnd >= this.transcript.cds().length() ? this.transcript.cds().substring(this.oldCodonCdsStart) : this.transcript.cds().substring(this.oldCodonCdsStart, this.oldCodonCdsEnd + 1);
        return codons;
    }
}

