/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;

public class Utr3prime
extends Utr {
    private static final long serialVersionUID = 5688641008301281991L;

    public Utr3prime() {
        this.type = EffectType.UTR_3_PRIME;
    }

    public Utr3prime(Exon parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.UTR_3_PRIME;
    }

    @Override
    public boolean isUtr3prime() {
        return true;
    }

    @Override
    public boolean isUtr5prime() {
        return false;
    }

    @Override
    int utrDistance(Variant variant, Transcript tr) {
        int cdsEnd = tr.getCdsEnd();
        if (cdsEnd < 0) {
            return -1;
        }
        if (this.isStrandPlus()) {
            return variant.getStart() - cdsEnd;
        }
        return cdsEnd - variant.getEnd();
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        if (variant.includes(this) && variant.getVariantType() == Variant.VariantType.DEL) {
            variantEffects.addEffectType(variant, this, EffectType.UTR_3_DELETED);
            return true;
        }
        Transcript tr = (Transcript)this.findParent(Transcript.class);
        int distance = this.utrDistance(variant, tr);
        VariantEffect variantEffect = new VariantEffect(variant);
        variantEffect.set(this, this.type, this.type.effectImpact(), distance >= 0 ? distance + " bases from CDS" : "");
        variantEffect.setDistance(distance);
        variantEffects.add(variantEffect);
        return true;
    }
}

