/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSeq;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.motif.Pwm;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public class Motif
extends Marker {
    private static final long serialVersionUID = 8464487883781181867L;
    public static final double SCORE_THRESHOLD = 0.01;
    public static final boolean debug = false;
    String pwmId;
    String pwmName;
    Pwm pwm;

    public Motif() {
        this.type = EffectType.MOTIF;
    }

    public Motif(Marker parent, int start, int end, boolean strandMinus, String id, String pwmName, String pwmId) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.MOTIF;
        this.pwmName = pwmName;
        this.pwmId = pwmId;
    }

    @Override
    public Motif cloneShallow() {
        Motif clone2 = (Motif)super.cloneShallow();
        clone2.pwmId = this.pwmId;
        clone2.pwmName = this.pwmName;
        return clone2;
    }

    VariantEffect.EffectImpact effectImpact(Variant variant) {
        VariantEffect.EffectImpact effectImpact = VariantEffect.EffectImpact.MODIFIER;
        if (this.pwm != null) {
            MarkerSeq mseq = new MarkerSeq((Marker)this.parent, this.start, this.end, false, this.id);
            String seqBest = this.pwm.getBestSequenceStr();
            mseq.setSequence(this.isStrandPlus() ? seqBest : GprSeq.reverseWc(seqBest));
            if (variant.isStrandMinus()) {
                throw new RuntimeException("Variants in minus strand are not supported!\n\t" + variant);
            }
            if (variant.isSnp() || variant.isMnp()) {
                double scoreNew;
                double scoreBest;
                double diff2;
                MarkerSeq mseqNew = mseq.apply(variant);
                String variantd = mseqNew.getSequence();
                if (this.isStrandMinus()) {
                    variantd = GprSeq.reverseWc(variantd);
                }
                if (Math.abs(diff2 = (scoreBest = this.pwm.score(seqBest)) - (scoreNew = this.pwm.score(variantd))) > 0.01) {
                    effectImpact = VariantEffect.EffectImpact.LOW;
                }
            } else if (variant.isInDel()) {
                effectImpact = VariantEffect.EffectImpact.LOW;
            }
        }
        return effectImpact;
    }

    public Pwm getPwm() {
        return this.pwm;
    }

    public String getPwmId() {
        return this.pwmId;
    }

    public String getPwmName() {
        return this.pwmName;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.pwmId = markerSerializer.getNextField();
        this.pwmName = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.pwmId + "\t" + this.pwmName;
    }

    public void setPwm(Pwm pwm) {
        this.pwm = pwm;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        variantEffects.add(variant, this, this.type, this.effectImpact(variant), "");
        return true;
    }
}

