/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteAcceptor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteDonor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteRegion;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import java.util.ArrayList;

public class Intron
extends Marker {
    private static final long serialVersionUID = -8283322526157264389L;
    int rank;
    Exon exonBefore;
    Exon exonAfter;
    ArrayList<SpliceSite> spliceSites;

    public Intron() {
        this.type = EffectType.INTRON;
        this.exonBefore = null;
        this.exonAfter = null;
        this.spliceSites = new ArrayList();
    }

    public Intron(Transcript parent, int start, int end, boolean strandMinus, String id, Exon exonBefore, Exon exonAfter) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.INTRON;
        this.exonAfter = exonAfter;
        this.exonBefore = exonBefore;
        this.spliceSites = new ArrayList();
    }

    public void add(SpliceSite ss) {
        this.spliceSites.add(ss);
    }

    @Override
    public Intron apply(Variant variant) {
        Intron newIntron = (Intron)super.apply(variant);
        if (newIntron == null) {
            return null;
        }
        newIntron.reset();
        for (SpliceSite ss : this.spliceSites) {
            SpliceSite newSs = (SpliceSite)ss.apply(variant);
            if (newSs == null) continue;
            newSs.setParent(newIntron);
            newIntron.add(newSs);
        }
        return newIntron;
    }

    @Override
    public Intron cloneShallow() {
        Intron clone2 = (Intron)super.cloneShallow();
        clone2.rank = this.rank;
        return clone2;
    }

    public SpliceSiteAcceptor createSpliceSiteAcceptor(int maxSpliceSiteSize) {
        int ssend;
        int ssstart;
        if ((maxSpliceSiteSize = Math.min(maxSpliceSiteSize, this.size())) <= 0) {
            return null;
        }
        if (this.isStrandPlus()) {
            ssstart = this.end - (maxSpliceSiteSize - 1);
            ssend = this.end;
        } else {
            ssstart = this.start;
            ssend = this.start + (maxSpliceSiteSize - 1);
        }
        SpliceSiteAcceptor spliceSiteAcceptor = new SpliceSiteAcceptor(this, ssstart, ssend, this.strandMinus, this.id);
        this.add(spliceSiteAcceptor);
        return spliceSiteAcceptor;
    }

    public SpliceSiteDonor createSpliceSiteDonor(int maxSpliceSiteSize) {
        int ssend;
        int ssstart;
        if ((maxSpliceSiteSize = Math.min(maxSpliceSiteSize, this.size())) <= 0) {
            return null;
        }
        if (this.isStrandPlus()) {
            ssstart = this.start;
            ssend = this.start + (maxSpliceSiteSize - 1);
        } else {
            ssstart = this.end - (maxSpliceSiteSize - 1);
            ssend = this.end;
        }
        SpliceSiteDonor spliceSiteDonor = new SpliceSiteDonor(this, ssstart, ssend, this.strandMinus, this.id);
        this.add(spliceSiteDonor);
        return spliceSiteDonor;
    }

    public SpliceSiteRegion createSpliceSiteRegionEnd(int sizeMin, int sizeMax) {
        if (sizeMin < 0) {
            return null;
        }
        if (sizeMax > this.size()) {
            sizeMax = this.size();
        }
        if (sizeMax <= sizeMin) {
            return null;
        }
        SpliceSiteRegion spliceSiteRegionEnd = null;
        spliceSiteRegionEnd = this.isStrandPlus() ? new SpliceSiteRegion(this, this.end - (sizeMax - 1), this.end - (sizeMin - 1), this.strandMinus, this.id) : new SpliceSiteRegion(this, this.start + sizeMin - 1, this.start + sizeMax - 1, this.strandMinus, this.id);
        if (spliceSiteRegionEnd != null) {
            this.add(spliceSiteRegionEnd);
        }
        return spliceSiteRegionEnd;
    }

    public SpliceSiteRegion createSpliceSiteRegionStart(int sizeMin, int sizeMax) {
        if (sizeMin < 0) {
            return null;
        }
        if (sizeMax > this.size()) {
            sizeMax = this.size();
        }
        if (sizeMax <= sizeMin) {
            return null;
        }
        SpliceSiteRegion spliceSiteRegionStart = null;
        spliceSiteRegionStart = this.isStrandPlus() ? new SpliceSiteRegion(this, this.start + (sizeMin - 1), this.start + (sizeMax - 1), this.strandMinus, this.id) : new SpliceSiteRegion(this, this.end - (sizeMax - 1), this.end - (sizeMin - 1), this.strandMinus, this.id);
        if (spliceSiteRegionStart != null) {
            this.add(spliceSiteRegionStart);
        }
        return spliceSiteRegionStart;
    }

    public Exon getExonAfter() {
        return this.exonAfter;
    }

    public Exon getExonBefore() {
        return this.exonBefore;
    }

    public int getRank() {
        return this.rank;
    }

    public ArrayList<SpliceSite> getSpliceSites() {
        return this.spliceSites;
    }

    public String getSpliceType() {
        return (this.exonBefore != null ? this.exonBefore.getSpliceType() : "") + "-" + (this.exonAfter != null ? this.exonAfter.getSpliceType() : "");
    }

    @Override
    public Markers query(Marker marker) {
        Markers markers = new Markers();
        for (SpliceSite ss : this.spliceSites) {
            if (!ss.intersects(marker)) continue;
            markers.add(ss);
        }
        return markers;
    }

    public void reset() {
        this.spliceSites = new ArrayList();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer);
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        for (SpliceSite ss : this.spliceSites) {
            if (!ss.intersects(variant)) continue;
            ss.variantEffect(variant, variantEffects);
        }
        variantEffects.addEffectType(variant, this, EffectType.INTRON);
        return true;
    }
}

