/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Intergenic;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Genes
implements Iterable<Gene>,
Serializable {
    private static final long serialVersionUID = 9022385501946879197L;
    public static final String CIRCULAR_GENE_ID = "_circ";
    public boolean debug = false;
    Genome genome;
    HashMap<String, Gene> genesById = new HashMap();

    public Genes(Genome genome) {
        this.genome = genome;
    }

    public void add(Gene gene) {
        this.genesById.put(gene.getId(), gene);
    }

    public void createCircularGenes() {
        LinkedList<Gene> newGenes = new LinkedList<Gene>();
        for (Gene g : this.genome.getGenes()) {
            Chromosome chr = g.getChromosome();
            Gene newGene = null;
            if (g.getStart() >= 0 && g.getEnd() <= chr.getEnd()) continue;
            newGene = (Gene)g.clone();
            newGene.setId(g.getId() + CIRCULAR_GENE_ID);
            for (Transcript tr : newGene) {
                tr.setId(tr.getId() + CIRCULAR_GENE_ID);
                for (Exon ex : tr) {
                    ex.setId(ex.getId() + CIRCULAR_GENE_ID);
                }
            }
            int shift = 0;
            if (g.getStart() < 0) {
                shift = chr.size();
            } else if (g.getEnd() > chr.getEnd()) {
                shift = -chr.size();
            }
            newGene.shiftCoordinates(shift);
            if (Config.get().isVerbose()) {
                Timer.showStdErr("Gene '" + g.getId() + "' spans across coordinate zero: Assuming circular chromosome, creating mirror gene at the end." + "\n\tGene        :" + g.toStr() + "\n\tNew gene    :" + newGene.toStr() + "\n\tChrsomosome :" + chr.toStr());
            }
            newGenes.add(newGene);
        }
        if (!newGenes.isEmpty()) {
            for (Gene g : newGenes) {
                this.genome.getGenes().add(g);
            }
            if (Config.get().isVerbose()) {
                Timer.showStdErr("Total: " + newGenes.size() + " added as circular mirrored genes (appended '" + CIRCULAR_GENE_ID + "' to IDs).");
            }
        }
    }

    public List<Intergenic> createIntergenic() {
        ArrayList<Intergenic> intergenics = new ArrayList<Intergenic>(this.genesById.size());
        ArrayList<Gene> genesSorted = new ArrayList<Gene>(this.genesById.size());
        genesSorted.addAll(this.genesById.values());
        Collections.sort(genesSorted);
        Interval genePrev = null;
        Chromosome chrPrev = null;
        for (Gene gene : genesSorted) {
            int end;
            int start;
            if (chrPrev != gene.getChromosome()) {
                genePrev = null;
            }
            if ((start = genePrev != null ? genePrev.getEnd() + 1 : 0) < (end = gene.getStart() - 1)) {
                String name = (genePrev != null ? ((Gene)genePrev).getGeneName() + "-" : "") + gene.getGeneName();
                String id = (genePrev != null ? genePrev.getId() + "-" : "") + gene.getId();
                Intergenic intergenic = new Intergenic(gene.getChromosome(), start, end, false, id, name);
                intergenics.add(intergenic);
            }
            if (genePrev == null || gene.getEnd() > genePrev.getEnd()) {
                genePrev = gene;
            }
            chrPrev = gene.getChromosome();
        }
        return intergenics;
    }

    public void createSpliceSites(int spliceSiteSize, int spliceRegionExonSize, int spliceRegionIntronMin, int spliceRegionIntronMax) {
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                tr.createSpliceSites(spliceSiteSize, spliceRegionExonSize, spliceRegionIntronMin, spliceRegionIntronMax);
            }
        }
    }

    public List<Marker> createUpDownStream(int upDownLength) {
        ArrayList<Marker> list2 = new ArrayList<Marker>();
        if (upDownLength <= 0) {
            return list2;
        }
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                tr.createUpDownStream(upDownLength);
                list2.add(tr.getUpstream());
                list2.add(tr.getDownstream());
            }
        }
        return list2;
    }

    public Gene get(String geneId) {
        return this.genesById.get(geneId);
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genesById.values().iterator();
    }

    public int size() {
        return this.genesById.size();
    }

    public Collection<Gene> sorted() {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        genes.addAll(this.genesById.values());
        Collections.sort(genes, new IntervalComparatorByStart());
        return genes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Gene gint : this) {
            sb.append(gint + "\n");
        }
        return sb.toString();
    }

    public Collection<Gene> values() {
        return this.genesById.values();
    }
}

