/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.IntervalAndSubIntervals;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteAcceptor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteBranch;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteDonor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteRegion;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.VariantNonRef;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.stats.ObservedOverExpectedCpG;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;

public class Gene
extends IntervalAndSubIntervals<Transcript>
implements Serializable {
    private static final long serialVersionUID = 8419206759034068147L;
    String geneName;
    String bioType;

    public Gene() {
        this.geneName = "";
        this.bioType = "";
        this.type = EffectType.GENE;
    }

    public Gene(Marker parent, int start, int end, boolean strandMinus, String id, String geneName, String bioType) {
        super(parent, start, end, strandMinus, id);
        this.geneName = geneName;
        this.bioType = bioType;
        this.type = EffectType.GENE;
    }

    public boolean adjust() {
        boolean newStrandMinus;
        boolean changed = false;
        int strandSumGene = 0;
        int newStart = this.start;
        int newEnd = this.start;
        if (newStart == 0 && newEnd == 0) {
            newStart = Integer.MAX_VALUE;
            newEnd = Integer.MIN_VALUE;
        }
        for (Transcript tr : this) {
            newStart = Math.min(newStart, tr.getStart());
            newEnd = Math.max(newEnd, tr.getEnd());
            for (Exon exon : tr.sortedStrand()) {
                newStart = Math.min(newStart, exon.getStart());
                newEnd = Math.max(newEnd, exon.getEnd());
                strandSumGene += exon.isStrandMinus() ? -1 : 1;
            }
            for (Utr utr : tr.getUtrs()) {
                newStart = Math.min(newStart, utr.getStart());
                newEnd = Math.max(newEnd, utr.getEnd());
            }
        }
        boolean bl = newStrandMinus = strandSumGene < 0;
        if (this.strandMinus != newStrandMinus) {
            this.strandMinus = newStrandMinus;
            changed = true;
        }
        if (newStart < newEnd) {
            if (this.start != newStart) {
                this.start = newStart;
                changed = true;
            }
            if (this.end != newEnd) {
                this.end = newEnd;
                changed = true;
            }
        } else {
            Gpr.debug("Gene '" + this.id + "' (name:'" + this.geneName + "') not adjusted: " + this);
        }
        return changed;
    }

    public Transcript canonical() {
        Transcript canonical = null;
        int canonicalLen = 0;
        if (this.isProteinCoding()) {
            for (Transcript t2 : this) {
                int tlen = t2.cds().length();
                if (!t2.isProteinCoding() || canonical != null && canonicalLen >= tlen && (canonicalLen != tlen || t2.getId().compareTo(canonical.getId()) >= 0)) continue;
                canonical = t2;
                canonicalLen = tlen;
            }
        } else {
            for (Transcript t3 : this) {
                int tlen = t3.mRna().length();
                if (canonicalLen > tlen || canonical != null && canonicalLen >= tlen && (canonicalLen != tlen || t3.getId().compareTo(canonical.getId()) >= 0)) continue;
                canonical = t3;
                canonicalLen = tlen;
            }
        }
        if (canonical != null) {
            canonical.setCanonical(true);
        }
        return canonical;
    }

    @Override
    public Gene cloneShallow() {
        Gene clone2 = (Gene)super.cloneShallow();
        clone2.bioType = this.bioType;
        clone2.geneName = this.geneName;
        return clone2;
    }

    public double cpgExonBias() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.oe(this);
    }

    public GeneType geneType() {
        if (this.bioType.length() > 0) {
            if (this.bioType.equalsIgnoreCase("protein_coding") || this.bioType.equalsIgnoreCase("mRNA")) {
                return GeneType.CODING;
            }
            return GeneType.NON_CODING;
        }
        return GeneType.UNKNOWN;
    }

    public String getBioType() {
        return this.bioType;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public boolean isProteinCoding() {
        for (Transcript tr : this) {
            if (!tr.isProteinCoding()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public int keepTranscripts(Set<String> trIds) {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        for (Transcript t2 : this) {
            if (trIds.contains(t2.getId())) continue;
            toDelete.add(t2);
        }
        for (Transcript t2 : toDelete) {
            this.remove(t2);
        }
        return toDelete.size();
    }

    public int keepTranscriptsProtein() {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        for (Transcript t2 : this) {
            if (t2.isProteinCoding()) continue;
            toDelete.add(t2);
        }
        for (Transcript t2 : toDelete) {
            this.remove(t2);
        }
        return toDelete.size();
    }

    @Override
    public Markers markers() {
        Markers markers = new Markers();
        for (Transcript tr : this) {
            markers.add(tr);
            markers.add(tr.markers());
        }
        return markers;
    }

    public void removeNonCanonical() {
        Transcript canonical = this.canonical();
        if (canonical != null) {
            ArrayList toDelete = new ArrayList();
            toDelete.addAll(this.subIntervals.values());
            toDelete.remove(canonical);
            for (Transcript t2 : toDelete) {
                this.remove(t2);
            }
        }
    }

    public boolean removeUnverified() {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        int countRemoved = 0;
        for (Transcript tr : this) {
            if (tr.isChecked() && !tr.isCorrected()) continue;
            toDelete.add(tr);
            ++countRemoved;
        }
        if (Config.get().isDebug()) {
            Gpr.debug("Gene '', removing " + countRemoved + " / " + this.numChilds() + " unchecked transcript.");
        }
        for (Transcript t2 : toDelete) {
            this.remove(t2);
        }
        return this.numChilds() <= 0;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.geneName = markerSerializer.getNextField();
        this.bioType = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.geneName + "\t" + this.bioType;
    }

    public void setBioType(String bioType) {
        this.bioType = bioType;
    }

    public int sizeof(String type) {
        EffectType eff = EffectType.valueOf(type.toUpperCase());
        Markers all = new Markers();
        int len = 0;
        switch (eff) {
            case GENE: {
                return this.size();
            }
            case EXON: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        all.add(exon);
                    }
                }
                break;
            }
            case CDS: {
                for (Transcript tr : this) {
                    for (Cds cds : tr.getCds()) {
                        all.add(cds);
                    }
                }
                break;
            }
            case TRANSCRIPT: {
                for (Transcript tr : this) {
                    all.add(tr);
                }
                break;
            }
            case INTRON: {
                return Math.max(0, this.sizeof("TRANSCRIPT") - this.sizeof("EXON"));
            }
            case UTR_3_PRIME: {
                for (Transcript tr : this) {
                    for (Utr3prime utr3prime : tr.get3primeUtrs()) {
                        all.add(utr3prime);
                    }
                }
                break;
            }
            case UTR_5_PRIME: {
                for (Transcript tr : this) {
                    for (Utr5prime utr5prime : tr.get5primeUtrs()) {
                        all.add(utr5prime);
                    }
                }
                break;
            }
            case UPSTREAM: {
                for (Transcript tr : this) {
                    all.add(tr.getUpstream());
                }
                break;
            }
            case DOWNSTREAM: {
                for (Transcript tr : this) {
                    all.add(tr.getDownstream());
                }
                break;
            }
            case SPLICE_SITE_ACCEPTOR: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        for (SpliceSite ss : exon.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteAcceptor)) continue;
                            all.add(ss);
                        }
                    }
                }
                break;
            }
            case SPLICE_SITE_BRANCH: {
                for (Transcript tr : this) {
                    for (SpliceSite spliceSite : tr.spliceSites()) {
                        if (!(spliceSite instanceof SpliceSiteBranch)) continue;
                        all.add(spliceSite);
                    }
                }
                break;
            }
            case SPLICE_SITE_DONOR: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        for (SpliceSite ss : exon.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteDonor)) continue;
                            all.add(ss);
                        }
                    }
                }
                break;
            }
            case SPLICE_SITE_REGION: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        for (SpliceSite ss : exon.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteRegion)) continue;
                            all.add(ss);
                        }
                    }
                    for (Intron intron : tr.introns()) {
                        for (SpliceSite ss : intron.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteRegion)) continue;
                            all.add(ss);
                        }
                    }
                }
            }
            case INTRAGENIC: {
                Markers gene = new Markers();
                gene.add(this);
                Markers trans = new Markers();
                for (Transcript transcript : this) {
                    trans.add(transcript);
                }
                all = gene.minus(trans);
                break;
            }
            case NONE: {
                return 0;
            }
            default: {
                throw new RuntimeException("Unimplemented sizeof('" + type + "')");
            }
        }
        Markers merged = all.merge();
        for (Marker m : merged) {
            len += m.size();
        }
        return len;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showTr) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + ":" + this.start + "-" + this.end);
        sb.append(", strand:" + (this.strandMinus ? "-1" : "1"));
        if (this.id != null && this.id.length() > 0) {
            sb.append(", id:" + this.id);
        }
        if (this.geneName != null && this.geneName.length() > 0) {
            sb.append(", name:" + this.geneName);
        }
        if (this.bioType != null && this.bioType.length() > 0) {
            sb.append(", bioType:" + this.bioType);
        }
        sb.append("\n");
        if (showTr && this.numChilds() > 0) {
            sb.append("Transcipts:\n");
            for (Transcript tint : this.sorted()) {
                sb.append("\t" + tint + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        Variant variantOri = variant;
        boolean shifted3prime = false;
        if (!variant.isSnp() && Config.get().isShiftHgvs() && this.isStrandPlus()) {
            shifted3prime = (variant = variant.realignLeft()) != variantOri;
        }
        boolean hitTranscript = false;
        for (Transcript tr : this) {
            if (variant.isNonRef()) {
                Variant vref = ((VariantNonRef)variant).getVariantRef();
                tr = tr.apply(vref);
            }
            hitTranscript |= tr.intersects(variant);
            tr.variantEffect(variant, variantEffects);
        }
        if (!hitTranscript) {
            variantEffects.add(variant, this, EffectType.INTRAGENIC, "");
            return true;
        }
        if (shifted3prime) {
            for (VariantEffect ve : variantEffects) {
                if (ve.getVariant() != variant) continue;
                ve.addErrorWarningInfo(VariantEffect.ErrorWarningType.INFO_REALIGN_3_PRIME);
            }
        }
        return true;
    }

    public static enum GeneType {
        CODING,
        NON_CODING,
        UNKNOWN;

    }
}

