/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import java.util.HashMap;

public class ChromosomeSimpleName {
    public static final String[] CHROMO_PREFIX = new String[]{"chromosome", "chromo", "chr"};
    private static ChromosomeSimpleName instance = new ChromosomeSimpleName();
    private final HashMap<String, String> map = new HashMap();

    public static String get(String chrName) {
        return instance.simpleNameCache(chrName);
    }

    private ChromosomeSimpleName() {
    }

    String removePrefix(String chr, String prefix) {
        String prefixLower;
        String chrLower = chr.toLowerCase();
        if (chrLower.startsWith(prefixLower = prefix.toLowerCase())) {
            return chr.substring(prefix.length());
        }
        return chr;
    }

    protected String simpleName(String chr) {
        if (chr == null) {
            return "";
        }
        chr = chr.trim();
        String chrPrev = "";
        do {
            chrPrev = chr;
            boolean exactMatch = false;
            for (String prefix : CHROMO_PREFIX) {
                exactMatch |= chr.equalsIgnoreCase(prefix);
            }
            if (!exactMatch) {
                for (String prefix : CHROMO_PREFIX) {
                    chr = this.removePrefix(chr, prefix + ":");
                    chr = this.removePrefix(chr, prefix + "_");
                    chr = this.removePrefix(chr, prefix + "-");
                    chr = this.removePrefix(chr, prefix);
                }
            }
            chr = this.removePrefix(chr, "0");
        } while (!(chr = chr.trim()).equals(chrPrev));
        return chr;
    }

    protected String simpleNameCache(String chrName) {
        String chr = this.map.get(chrName);
        if (chr == null) {
            chr = this.simpleName(chrName);
            this.map.put(chrName, chr);
        }
        return chr;
    }
}

