/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.geneSets.algorithm;

import ca.mcgill.mcb.pcingola.geneSets.GeneSet;
import ca.mcgill.mcb.pcingola.geneSets.GeneSets;
import ca.mcgill.mcb.pcingola.geneSets.GeneSetsRanked;
import ca.mcgill.mcb.pcingola.geneSets.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apfloat.Apfloat;

public abstract class EnrichmentAlgorithm {
    public static final int HTML_TD_GENES_MAX_LEN = 40;
    public static final String[] HTML_BG_COLOR = new String[]{"dddddd", "eeeeee"};
    public static final String HTML_BG_COLOR_TITLE = "cccccc";
    boolean debug = false;
    boolean verbose = false;
    boolean htmlTable = false;
    int minGeneSetSize = 0;
    int maxGeneSetSize = Integer.MAX_VALUE;
    int numberToSelect;
    double maxPValue = Double.NaN;
    double maxPvalueAdjusted = 0.05;
    StringBuilder output = new StringBuilder();
    GeneSets geneSets;
    Set<String> filterOutputGeneSets;
    public static long PRINT_SOMETHING_TIME = 5000L;

    public EnrichmentAlgorithm(GeneSets geneSets, int numberToSelect) {
        this.geneSets = geneSets;
        this.numberToSelect = numberToSelect;
    }

    public double getMaxPvalueAdjusted() {
        return this.maxPvalueAdjusted;
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    protected boolean isShow(Result result2) {
        if (Double.isNaN(this.maxPValue) ? result2.getPvalueAdjusted() >= this.maxPvalueAdjusted : result2.getPvalue().doubleValue() >= this.maxPValue) {
            return false;
        }
        if (this.filterOutputGeneSets != null) {
            String gsName = result2.getLatestGeneSet().getName();
            boolean show = this.filterOutputGeneSets.contains(gsName);
            if (this.verbose) {
                System.err.println("\tFilter output list. Show geneSet '" + gsName + "' : " + show);
            }
            return show;
        }
        return true;
    }

    protected void print(String str) {
        System.out.println(str);
        this.output.append(str + "\n");
    }

    void printEnd() {
        if (this.htmlTable) {
            this.print("</table>");
        }
    }

    void printResult(int it, Result result2) {
        if (result2 != null && result2.getLatestGeneSet() != null && this.isShow(result2)) {
            GeneSet geneSet = result2.getLatestGeneSet();
            StringBuffer interestingGenes = new StringBuffer();
            ArrayList<String> genesList = new ArrayList<String>();
            genesList.addAll(geneSet.getInterestingGenes());
            Collections.sort(genesList);
            for (String gene : genesList) {
                interestingGenes.append(gene);
                if (this.geneSets.hasValue(gene) || this.geneSets.isRanked()) {
                    interestingGenes.append("[");
                    if (this.geneSets.hasValue(gene)) {
                        interestingGenes.append(this.geneSets.getValue(gene));
                    }
                    if (this.geneSets.isRanked()) {
                        GeneSetsRanked geneSetsRanked = (GeneSetsRanked)this.geneSets;
                        interestingGenes.append("/" + geneSetsRanked.getRank(gene));
                    }
                    interestingGenes.append("]");
                }
                interestingGenes.append(" ");
            }
            if (this.htmlTable) {
                String descr = geneSet.getDescription();
                String name = geneSet.getName();
                if (descr.startsWith("http://")) {
                    name = "<a href=\"" + descr + "\">" + name + "</a>";
                    descr = "<a href=\"" + descr + "\">link</a>";
                }
                String intGenes = interestingGenes.toString();
                if (interestingGenes.length() > 40) {
                    intGenes = "<textarea rows=1 cols=40>" + interestingGenes + "</textarea>";
                }
                String bgcolor = HTML_BG_COLOR[it % 2];
                this.print("\t<tr bgcolor=\"" + bgcolor + "\"> <td nowrap>" + it + "</td>\t<td nowrap>" + String.format("%.2e", result2.getPvalue().doubleValue()) + "</td>\t<td nowrap>" + String.format("%.2e", result2.getPvalueAdjusted()) + "</td>\t<td nowrap>" + name + "</td>\t<td nowrap>" + geneSet.size() + "</td>\t<td nowrap>" + descr + "</td>\t<td nowrap>" + intGenes + "</td>\t<td nowrap>" + (this.geneSets.isRanked() ? geneSet.rankSum() : 0L) + "</td>\t</tr>");
            } else {
                this.print(it + "\t" + result2.getPvalue() + "\t" + result2.getPvalueAdjusted() + "\t" + geneSet.getName() + "\t" + geneSet.size() + "\t" + geneSet.getDescription() + "\t" + result2.getGeneSets() + "\t" + interestingGenes + "\t" + (this.geneSets.isRanked() ? geneSet.rankSum() : 0L));
            }
        }
    }

    void printTitle() {
        if (this.htmlTable) {
            this.print("<table border=0> <tr bgcolor=\"cccccc\"> <th>Rank</th>\t<th>p-value</th>\t<th>p-value adj</th>\t<th>Latest result</th>\t<th>Size</th>\t<th>Description</th>\t<th>Interesting genes </th>\t<th> Score </th> </tr>");
        } else if (this.verbose) {
            this.print("Iteration\tp-value\tp-value adj\tLatest result\tSize\tDescription\tResult\tInteresting genes");
        }
    }

    abstract Apfloat pValue(GeneSet var1);

    Apfloat pValue(List<GeneSet> geneSetList) {
        GeneSet newGeneSet = new GeneSet(geneSetList, this.geneSets);
        return this.pValue(newGeneSet);
    }

    public Result select() {
        Result best = new Result();
        ArrayList<Result> results = new ArrayList<Result>();
        for (GeneSet geneSet : this.geneSets) {
            if (geneSet.getGeneCount() <= 0 || geneSet.getGeneCount() < this.minGeneSetSize || geneSet.getGeneCount() > this.maxGeneSetSize) continue;
            Apfloat pValue = this.pValue(geneSet);
            Result result2 = new Result(geneSet, pValue, 0);
            results.add(result2);
        }
        for (Result res : results) {
            res.setGeneSetCountLast(results.size());
        }
        if (this.htmlTable || this.verbose) {
            this.printTitle();
            Collections.sort(results);
            int rank = 1;
            for (Result r : results) {
                this.printResult(rank++, r);
            }
            this.printEnd();
        }
        return best;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFilterOutputGeneSets(Set<String> filterOutputGeneSets) {
        this.filterOutputGeneSets = filterOutputGeneSets;
    }

    public void setHtmlTable(boolean htmlTable) {
        this.htmlTable = htmlTable;
    }

    public void setMaxGeneSetSize(int maxGeneSetSize) {
        this.maxGeneSetSize = maxGeneSetSize;
    }

    public void setMaxPValue(double maxPValue) {
        this.maxPValue = maxPValue;
    }

    public void setMaxPvalueAdjusted(double maxPvalueAdjusted) {
        this.maxPvalueAdjusted = maxPvalueAdjusted;
    }

    public void setMinGeneSetSize(int minGeneSetSize) {
        this.minGeneSetSize = minGeneSetSize;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static enum EnrichmentAlgorithmType {
        FISHER_GREEDY,
        RANKSUM_GREEDY,
        FISHER,
        RANKSUM,
        LEADING_EDGE_FRACTION,
        NONE;


        public boolean isBinary() {
            return this == FISHER || this == FISHER_GREEDY;
        }

        public boolean isGreedy() {
            return this == FISHER_GREEDY || this == RANKSUM_GREEDY;
        }

        public boolean isRank() {
            return this == RANKSUM || this == RANKSUM_GREEDY;
        }
    }
}

