/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.geneSets;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;

public class GeneStats {
    String geneName;
    boolean proteinCoding = false;
    int geneLength = 0;
    int numberOfTranscripts = 0;
    int numberOfExonsTotal = 0;
    int numberOfExonsMax = 0;
    int cdsLengthTotal = 0;
    int cdsLengthMax = 0;
    int aaLengthTotal = 0;
    int aaLengthMax = 0;
    int aaLengthCount = 0;

    public void add(Gene gene) {
        this.add(gene, false);
    }

    public void add(Gene gene, boolean useGeneId) {
        if (this.geneName == null) {
            this.geneName = useGeneId ? gene.getId() : gene.getGeneName();
        }
        this.proteinCoding |= gene.isProteinCoding();
        this.geneLength += gene.size();
        for (Transcript tr : gene) {
            if (tr.hasError()) continue;
            ++this.numberOfTranscripts;
            this.numberOfExonsTotal += tr.numChilds();
            this.numberOfExonsMax = Math.max(this.numberOfExonsMax, tr.numChilds());
            int cdsLen = tr.cds().length();
            this.cdsLengthTotal += cdsLen;
            this.cdsLengthMax = Math.max(this.cdsLengthMax, cdsLen);
            if (!tr.isProteinCoding() || cdsLen <= 0) continue;
            int aaLen = cdsLen / 3;
            this.aaLengthTotal += aaLen;
            this.aaLengthMax = Math.max(this.aaLengthMax, aaLen);
            ++this.aaLengthCount;
        }
    }

    public String title() {
        return "proteinCoding\tgeneLength\tnumberOfTranscripts\tnumberOfExonsAvg\tnumberOfExonsMax\tcdsLengthAvg\tcdsLengthMax\taaLengthAvg\taaLengthMax\taaLengthCount";
    }

    public String toString() {
        double numberOfExonsAvg = 0.0;
        double cdsLengthAvg = 0.0;
        double aaLengthAvg = 0.0;
        if (this.numberOfTranscripts > 0) {
            numberOfExonsAvg = (double)this.numberOfExonsTotal / (double)this.numberOfTranscripts;
            cdsLengthAvg = (double)this.cdsLengthTotal / (double)this.numberOfTranscripts;
        }
        if (this.aaLengthCount > 0) {
            aaLengthAvg = (double)this.aaLengthTotal / (double)this.aaLengthCount;
        }
        return this.proteinCoding + "\t" + this.geneLength + "\t" + this.numberOfTranscripts + "\t" + numberOfExonsAvg + "\t" + this.numberOfExonsMax + "\t" + cdsLengthAvg + "\t" + this.cdsLengthMax + "\t" + aaLengthAvg + "\t" + this.aaLengthMax + "\t" + this.aaLengthCount;
    }
}

