/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import scala.collection.mutable.StringBuilder;

public class TableFile
implements Serializable {
    private static final long serialVersionUID = 9180460090637138107L;
    protected static final char FIELD_NAME_SEPARATOR = ';';
    protected int size;
    protected boolean verbose;
    protected boolean hasTitle;
    protected String fileName;
    protected String separator = "\t";
    protected String fieldStr;
    protected String[] fieldNames;
    protected HashMap<String, Field> fieldByName;

    public TableFile(int size2) {
        this.size = size2;
        this.initArrays(size2);
    }

    public TableFile(String fileName) {
        this.init(fileName, this.guessFields());
    }

    public TableFile(String fileName, String fieldStr) {
        this.init(fileName, fieldStr);
    }

    protected void assign(String line, int idx) {
        String[] vals = line.split(this.separator);
        int maxFieldNum = Math.min(vals.length, this.fieldNames.length);
        for (int i = 0; i < maxFieldNum; ++i) {
            if (this.fieldNames[i].isEmpty()) continue;
            try {
                Field field2 = this.fieldByName.get(this.fieldNames[i]);
                Object array = field2.get(this);
                String typeName = field2.getType().getCanonicalName();
                Object value2 = null;
                String valOri = vals[i];
                if (typeName.equals("java.lang.String[]")) {
                    value2 = valOri;
                } else {
                    String valTrim = valOri.trim();
                    if (typeName.equals("int[]")) {
                        value2 = Gpr.parseIntSafe(valTrim);
                    } else if (typeName.equals("long[]")) {
                        value2 = Gpr.parseLongSafe(valTrim);
                    } else if (typeName.equals("double[]")) {
                        value2 = Gpr.parseDoubleSafe(valTrim);
                    } else if (typeName.equals("float[]")) {
                        value2 = Float.valueOf(Gpr.parseFloatSafe(valTrim));
                    } else if (typeName.equals("boolean[]")) {
                        value2 = Gpr.parseBoolSafe(valTrim);
                    } else {
                        throw new RuntimeException("Unsoported parsing for object type '" + typeName + "' cannot be parsed.");
                    }
                }
                Array.set(array, idx, value2);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    String guessFields() {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        for (Field f2 : fields = this.getClass().getFields()) {
            sb.append(f2.getName() + ';');
        }
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    void init(String fileName, String fieldStr) {
        this.fileName = fileName;
        this.fieldStr = fieldStr;
        this.verbose = false;
        this.hasTitle = true;
        if (fileName != null) {
            this.load();
        }
    }

    void initArrays(int size2) {
        this.initFields();
        for (Field f2 : this.fieldByName.values()) {
            String canName = f2.getType().getCanonicalName();
            int idx = canName.indexOf(91);
            if (idx < 0) {
                throw new RuntimeException("Cannot parse aarray class '" + canName + "'");
            }
            String baseClassName = canName.substring(0, idx);
            try {
                Class<Comparable<Integer>> clazz = null;
                clazz = baseClassName.equals("int") ? Integer.TYPE : (baseClassName.equals("byte") ? Byte.TYPE : (baseClassName.equals("short") ? Short.TYPE : (baseClassName.equals("long") ? Long.TYPE : (baseClassName.equals("double") ? Double.TYPE : (baseClassName.equals("float") ? Float.TYPE : (baseClassName.equals("boolean") ? Boolean.TYPE : (baseClassName.equals("char") ? Character.TYPE : Class.forName(baseClassName))))))));
                Object array = Array.newInstance(clazz, size2);
                f2.set(this, array);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void initFields() {
        if (this.fieldByName == null) {
            if (this.fieldStr == null) {
                this.fieldStr = this.guessFields();
            }
            this.fieldNames = this.fieldStr.split(";");
            this.fieldByName = new HashMap();
            for (String fname : this.fieldNames) {
                try {
                    if (fname.isEmpty()) continue;
                    Field field2 = this.getClass().getField(fname);
                    this.fieldByName.put(fname, field2);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("Error: Field '" + fname + "' not found for class '" + this.getClass().getCanonicalName() + "' (may be the fields is not public?)");
                }
            }
        }
    }

    public void load() {
        this.initFields();
        if (this.verbose) {
            Timer.showStdErr("Counting lines from '" + this.fileName + "'");
        }
        this.size = Gpr.countLines(this.fileName);
        if (this.hasTitle) {
            --this.size;
        }
        if (this.verbose) {
            Timer.showStdErr("Done. " + this.size + " data lines.");
        }
        this.initArrays(this.size);
        if (this.verbose) {
            Timer.showStdErr("Loading file '" + this.fileName + "'");
        }
        int idx = 0;
        LineFileIterator lfi = new LineFileIterator(this.fileName);
        for (String line : lfi) {
            if (lfi.lineNum <= 1 && this.hasTitle) continue;
            this.assign(line, idx++);
        }
        if (this.verbose) {
            Timer.showStdErr("Done. " + idx + " lines loaded.");
        }
        lfi.close();
    }

    public void save(String binaryFile) {
        this.fieldByName = null;
        if (this.verbose) {
            Timer.showStdErr("Saving to file '" + binaryFile + "'");
        }
        Gpr.toFileSerialize(binaryFile, this);
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
    }

    public int size() {
        return this.size;
    }

    public String toString(int index) {
        StringBuilder sb = new StringBuilder();
        this.initFields();
        for (String fname : this.fieldNames) {
            if (fname.isEmpty()) continue;
            try {
                Field f2 = this.fieldByName.get(fname);
                Object array = f2.get(this);
                Object value2 = Array.get(array, index);
                sb.append(value2 + "\t");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sb.toString();
    }
}

