/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Motif;
import ca.mcgill.mcb.pcingola.motif.Jaspar;
import java.io.IOException;

public class MotifFileIterator
extends MarkerFileIterator<Motif> {
    public static final int GFF_OFFSET = 1;
    Jaspar jaspar;

    public MotifFileIterator(String fileName, Genome genome, Jaspar jaspar) {
        super(fileName, genome, 1);
        this.jaspar = jaspar;
    }

    @Override
    protected Motif readNext() {
        try {
            while (this.ready()) {
                String[] infos;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\t")).length < 3) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int start = this.parsePosition(fields[3]);
                int end = this.parsePosition(fields[4]);
                String id = "line_" + this.lineNum;
                String strandStr = fields[6];
                boolean strandMinus = strandStr.equals("-");
                String info = fields[8];
                String name = "";
                String pwmId = "";
                for (String nv : infos = info.split(";")) {
                    String[] nameValue = nv.split("=");
                    if (nameValue.length <= 0) continue;
                    String attr = nameValue[0].trim();
                    String val = nameValue[1].trim();
                    if (!attr.equals("Name")) continue;
                    name = val;
                    String[] names = name.split(":");
                    name = names[0];
                    pwmId = names[names.length - 1];
                }
                Motif motif = new Motif(chromo, start, end, strandMinus, id, name, pwmId);
                motif.setPwm(this.jaspar.getPwm(pwmId));
                if (motif.getPwm() == null) {
                    System.err.println("Warning: Pwm '" + id + "' not found! Name = " + name);
                }
                return motif;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

