/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.FileIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import scala.collection.mutable.StringBuilder;

public class LineClassFileIterator<T>
extends FileIterator<T> {
    public static boolean debug = false;
    public static final char FIELD_NAME_SEPARATOR = ';';
    protected String separator = "\t";
    protected String fieldStr;
    protected String[] fieldNames;
    protected HashMap<String, Field> fieldByName;
    protected Class clazz;

    public LineClassFileIterator(String fileName, Class clazz) {
        super(fileName);
        this.line = null;
        this.lineNum = 0;
        this.reader = null;
        this.clazz = clazz;
        this.reader = Gpr.reader(fileName);
        this.fieldStr = this.guessFields();
        if (this.fieldStr != null) {
            this.fieldMap();
        }
    }

    public LineClassFileIterator(String fileName, Class clazz, String fieldNames) {
        super(fileName);
        this.line = null;
        this.lineNum = 0;
        this.reader = null;
        this.clazz = clazz;
        this.reader = Gpr.reader(fileName);
        this.fieldStr = fieldNames;
        if (this.fieldStr != null) {
            this.fieldMap();
        }
    }

    protected T createObject(String line) {
        Object tObj;
        String[] vals = line.split(this.separator);
        try {
            tObj = this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int maxFieldNum = Math.min(vals.length, this.fieldNames.length);
        for (int i = 0; i < maxFieldNum; ++i) {
            if (this.fieldNames[i].isEmpty()) continue;
            Field field2 = this.fieldByName.get(this.fieldNames[i]);
            String typeName = field2.getType().getCanonicalName();
            try {
                String valOri = vals[i];
                if (typeName.equals("java.lang.String")) {
                    field2.set(tObj, valOri);
                    continue;
                }
                String valTrim = valOri.trim();
                if (typeName.equals("int")) {
                    field2.setInt(tObj, Gpr.parseIntSafe(valTrim));
                    continue;
                }
                if (typeName.equals("long")) {
                    field2.setLong(tObj, Gpr.parseLongSafe(valTrim));
                    continue;
                }
                if (typeName.equals("double")) {
                    field2.setDouble(tObj, Gpr.parseDoubleSafe(valTrim));
                    continue;
                }
                if (typeName.equals("float")) {
                    field2.setFloat(tObj, Gpr.parseFloatSafe(valTrim));
                    continue;
                }
                throw new RuntimeException("Unsoported parsing for object type '" + typeName + "' cannot be parsed.");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return tObj;
    }

    protected void fieldMap() {
        this.fieldNames = this.fieldStr.split(";");
        this.fieldByName = new HashMap();
        for (String fname : this.fieldNames) {
            try {
                if (fname.isEmpty()) continue;
                Field field2 = this.clazz.getField(fname);
                this.fieldByName.put(fname, field2);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Error: Field '" + fname + "' not found for class '" + this.clazz.getCanonicalName() + "' (may be the fields is not public?)");
            }
        }
    }

    String guessFields() {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        for (Field f2 : fields = this.clazz.getFields()) {
            sb.append(f2.getName() + ';');
        }
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    protected T readNext() {
        try {
            if (this.reader.ready()) {
                while ((this.line = this.reader.readLine()) != null) {
                    if (this.line.trim().isEmpty()) continue;
                    ++this.lineNum;
                    return this.createObject(this.line);
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

