/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.VariantFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.VariantWithScore;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;

public class BedFileIterator
extends VariantFileIterator {
    public BedFileIterator(String fileName) {
        super(fileName);
        this.inOffset = 0;
    }

    public BedFileIterator(String fileName, Genome genome) {
        super(fileName, genome);
        this.inOffset = 0;
    }

    @Override
    protected Variant readNext() {
        try {
            while (this.ready()) {
                int start;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\\t")).length < 2) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int end = start = this.parsePosition(fields[1]);
                if (fields.length > 2) {
                    end = this.parsePosition(fields[2]) - 1;
                }
                if (end < start) {
                    end = start;
                }
                String id = "line_" + this.lineNum;
                if (fields.length > 3 && !fields[3].isEmpty()) {
                    id = fields[3];
                }
                double score = 0.0;
                if (fields.length > 4) {
                    score = Gpr.parseDoubleSafe(fields[4]);
                }
                VariantWithScore variant = new VariantWithScore((Marker)chromo, start, end, id, score);
                variant.setChromosomeNameOri(chromosome);
                return variant;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

