/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.coverage;

import java.io.Serializable;

public class CoverageChr
implements Serializable {
    private static final long serialVersionUID = -5620938926858131251L;
    short[] count;

    public CoverageChr(int len) {
        this.count = new short[len];
    }

    public double avgCoverage(int start, int end) {
        return (double)this.coverage(start, end) / (double)(end - start + 1);
    }

    public long coverage(int start, int end) {
        long sum2 = 0L;
        for (int i = start; i <= end; ++i) {
            sum2 += (long)this.count[i];
        }
        return sum2;
    }

    public short[] getCount() {
        return this.count;
    }

    public void inc(int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (this.count[i] >= Short.MAX_VALUE) continue;
            int n = i;
            this.count[n] = (short)(this.count[n] + 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] == 0) continue;
            sb.append(i + "\t" + this.count[i] + "\n");
        }
        return sb.toString();
    }
}

