/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.binseq.coder;

import ca.mcgill.mcb.pcingola.binseq.coder.Coder;
import ca.mcgill.mcb.pcingola.nmer.Nmer;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class DnaCoder
extends Coder {
    private static final long serialVersionUID = 1L;
    public static boolean debug = false;
    private static DnaCoder dnaCoder = new DnaCoder();
    protected static final int BITS_PER_BASE = 2;
    protected static final long MASK_FIRST_BASE = 3L;
    protected static final int BASES_PER_LONGWORD = 32;
    protected static final int LAST_BASE_IN_LONGWORD = 31;
    public static final long MASK_ALL_WORD = -1L;
    public static final char[] TO_BASE = new char[]{'a', 'c', 'g', 't'};
    public long[] MASK_BASE = new long[32];
    public long[] MASK_LOW = new long[65];
    public long[] MASK_HIGH = new long[65];
    public int[] COUNT_DIFFS;

    public static DnaCoder get() {
        return dnaCoder;
    }

    DnaCoder() {
        for (int i = 0; i < this.MASK_BASE.length; ++i) {
            this.MASK_BASE[i] = 3L << 2 * i;
        }
        long low = 1L;
        long high = Long.MIN_VALUE;
        this.MASK_HIGH[0] = 0L;
        this.MASK_LOW[0] = 0L;
        for (int i = 1; i < this.MASK_LOW.length; ++i) {
            int j = i - 1;
            this.MASK_LOW[i] = low = 1L << j | low;
            this.MASK_HIGH[i] = high >> j;
        }
        int countDiffLen = 16;
        this.COUNT_DIFFS = new int[1 << countDiffLen - 1 + 1];
        for (int i = 1; i < this.COUNT_DIFFS.length; ++i) {
            int count2 = 0;
            for (int j = 0; j <= countDiffLen; j += 2) {
                if ((i >> j & 3) == 0) continue;
                ++count2;
            }
            this.COUNT_DIFFS[i] = count2;
        }
    }

    @Override
    public int basesPerWord() {
        return 32;
    }

    @Override
    public int baseToBits(char c) {
        return this.baseToBits(c, false);
    }

    public int baseToBits(char c, boolean ignoreErrors) {
        switch (c) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 3;
            }
        }
        if (ignoreErrors) {
            return 0;
        }
        throw new RuntimeException("Unknown base '" + c + "'");
    }

    @Override
    public int bitsPerBase() {
        return 2;
    }

    public void copyBases(long[] src, int srcStart, long[] dst, int dstStart, int length) {
        int startWord = srcStart / 32;
        int startBase = srcStart % 32;
        long startMask = this.MASK_LOW[64 - startBase * 2];
        int startWordDst = dstStart / 32;
        int startBaseDst = dstStart % 32;
        int endWordDst = (dstStart + length - 1) / 32;
        int endBaseDst = (startBaseDst + length) % 32;
        long startMaskDst = this.MASK_LOW[64 - startBaseDst * 2];
        long endMaskDst = endBaseDst != 0 ? this.MASK_HIGH[endBaseDst * 2] : -1L;
        int rolLsrc = 2 * startBase;
        int rorHsrc = 64 - rolLsrc;
        int rorLdst = startBaseDst * 2;
        int rorHdst = 64 - rorLdst;
        long srcL = 0L;
        long srcH = 0L;
        int i = startWord;
        int j = startWordDst;
        for (int k = 0; k < length; k += 32) {
            srcL = (src[i] & startMask) << rolLsrc;
            srcH = startBase != 0 && i + 1 < src.length ? src[i + 1] >>> rorHsrc : 0L;
            long s = srcH | srcL;
            if (j < dst.length) {
                long mask = j == endWordDst ? startMaskDst ^ 0xFFFFFFFFFFFFFFFFL | endMaskDst ^ 0xFFFFFFFFFFFFFFFFL : startMaskDst ^ 0xFFFFFFFFFFFFFFFFL;
                dst[j] = dst[j] & mask | s >>> rorLdst & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                if (j + 1 <= endWordDst) {
                    mask = j + 1 == endWordDst ? startMaskDst | endMaskDst ^ 0xFFFFFFFFFFFFFFFFL : startMaskDst;
                    dst[j + 1] = dst[j + 1] & mask | s << rorHdst & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            ++i;
            ++j;
        }
    }

    public void copyBases(long[] src, long[] dst, int start, int length) {
        int startWord = start / 32;
        int startBase = start % 32;
        int endWord = (start + length) / 32;
        int endBase = (startBase + length) % 32;
        int len = (startBase + length) / 32;
        long startMask = this.MASK_LOW[64 - startBase * 2];
        long endMask = this.MASK_HIGH[endBase * 2];
        if (len == 0) {
            long dstMaskedOut = dst[startWord] & (startMask & endMask ^ 0xFFFFFFFFFFFFFFFFL);
            dst[startWord] = dstMaskedOut | src[startWord] & startMask & endMask;
        } else if (len == 1) {
            long dstMaskedOut = dst[startWord] & (startMask ^ 0xFFFFFFFFFFFFFFFFL);
            dst[startWord] = dstMaskedOut | src[startWord] & startMask;
            dstMaskedOut = dst[endWord] & (endMask ^ 0xFFFFFFFFFFFFFFFFL);
            dst[endWord] = dstMaskedOut | src[endWord] & endMask;
        } else {
            long dstMaskedOut = dst[startWord] & (startMask ^ 0xFFFFFFFFFFFFFFFFL);
            dst[startWord] = dstMaskedOut | src[startWord] & startMask;
            dstMaskedOut = dst[endWord] & (endMask ^ 0xFFFFFFFFFFFFFFFFL);
            dst[endWord] = dstMaskedOut | src[endWord] & endMask;
            System.arraycopy(src, startWord + 1, dst, startWord + 1, len - 1);
        }
    }

    int countDiffBases(long compare) {
        int comp = this.COUNT_DIFFS[(int)(compare & 0xFFFFL)];
        comp += this.COUNT_DIFFS[(int)(compare >> 16 & 0xFFFFL)];
        comp += this.COUNT_DIFFS[(int)(compare >> 32 & 0xFFFFL)];
        return comp += this.COUNT_DIFFS[(int)(compare >> 48 & 0xFFFFL)];
    }

    void d(String m, long l) {
        Nmer n = new Nmer(32);
        n.setNmer(l);
        Gpr.debug(String.format("%10s\t%s\t%s", m, Gpr.bin64(l), n.toString()));
    }

    @Override
    public int decodeWord(long word, int pos) {
        int c = (int)((word & this.MASK_BASE[pos]) >>> (pos << 1));
        return c;
    }

    public long encodeWord(char base, int pos) {
        return (long)this.baseToBits(base) << (pos << 1);
    }

    @Override
    public int lastBaseinWord() {
        return 31;
    }

    public int length2words(int len) {
        return len % this.basesPerWord() != 0 ? len / this.basesPerWord() + 1 : len / this.basesPerWord();
    }

    @Override
    public long mask(int baseIndexInWord) {
        return this.MASK_BASE[baseIndexInWord];
    }

    public long replaceBase(long code, int pos, char newBase) {
        return code & (this.MASK_BASE[pos] ^ 0xFFFFFFFFFFFFFFFFL) | this.encodeWord(newBase, pos);
    }

    public long reverseBases(long code) {
        long reversedCode = 0L;
        for (int pos = 0; pos < this.basesPerWord(); ++pos) {
            int c = this.decodeWord(code, pos);
            reversedCode = reversedCode << 2 | (long)c;
        }
        return reversedCode;
    }

    public int score(long[] dst, long[] src, int srcStart, int length, int threshold) {
        int startWord = srcStart / 32;
        int startBase = srcStart % 32;
        long startMask = this.MASK_LOW[64 - startBase * 2];
        int endWordDst = (length - 1) / 32;
        int endBaseDst = length % 32;
        long endMaskDst = endBaseDst != 0 ? this.MASK_HIGH[endBaseDst * 2] : -1L;
        int rolLsrc = 2 * startBase;
        int rorHsrc = 64 - rolLsrc;
        long srcL = 0L;
        long srcH = 0L;
        int diffBases = 0;
        int i = startWord;
        int j = 0;
        for (int k = 0; k < length; k += 32) {
            long mask;
            long compare;
            srcL = (src[i] & startMask) << rolLsrc;
            srcH = startBase != 0 && i + 1 < src.length ? src[i + 1] >>> rorHsrc : 0L;
            long s = srcH | srcL;
            if (j < dst.length && (compare = (dst[j] ^ s) & (mask = j == endWordDst ? endMaskDst : -1L)) != 0L) {
                if (threshold == 0) {
                    return 0;
                }
                if ((diffBases += this.countDiffBases(compare)) > threshold) {
                    return 0;
                }
            }
            ++i;
            ++j;
        }
        return length - diffBases;
    }

    @Override
    public char toBase(int code) {
        return TO_BASE[code];
    }

    @Override
    public char toBase(long word, int pos) {
        int c = (int)((word & this.MASK_BASE[pos]) >>> (pos << 1));
        return this.toBase(c);
    }
}

