/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.dfa.DFASerializer;
import org.antlr.v4.runtime.dfa.DFAState;
import org.antlr.v4.runtime.dfa.LexerDFASerializer;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;

public class DFA {
    @NotNull
    public final Map<DFAState, DFAState> states = new HashMap<DFAState, DFAState>();
    @Nullable
    public volatile DFAState s0;
    public final int decision;
    @NotNull
    public final DecisionState atnStartState;
    private volatile boolean precedenceDfa;

    public DFA(@NotNull DecisionState atnStartState) {
        this(atnStartState, 0);
    }

    public DFA(@NotNull DecisionState atnStartState, int decision) {
        this.atnStartState = atnStartState;
        this.decision = decision;
    }

    public final boolean isPrecedenceDfa() {
        return this.precedenceDfa;
    }

    public final DFAState getPrecedenceStartState(int precedence) {
        if (!this.isPrecedenceDfa()) {
            throw new IllegalStateException("Only precedence DFAs may contain a precedence start state.");
        }
        if (precedence < 0 || precedence >= this.s0.edges.length) {
            return null;
        }
        return this.s0.edges[precedence];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPrecedenceStartState(int precedence, DFAState startState) {
        if (!this.isPrecedenceDfa()) {
            throw new IllegalStateException("Only precedence DFAs may contain a precedence start state.");
        }
        if (precedence < 0) {
            return;
        }
        DFAState dFAState = this.s0;
        synchronized (dFAState) {
            if (precedence >= this.s0.edges.length) {
                this.s0.edges = Arrays.copyOf(this.s0.edges, precedence + 1);
            }
            this.s0.edges[precedence] = startState;
        }
    }

    public final synchronized void setPrecedenceDfa(boolean precedenceDfa) {
        if (this.precedenceDfa != precedenceDfa) {
            this.states.clear();
            if (precedenceDfa) {
                DFAState precedenceState = new DFAState(new ATNConfigSet());
                precedenceState.edges = new DFAState[0];
                precedenceState.isAcceptState = false;
                precedenceState.requiresFullContext = false;
                this.s0 = precedenceState;
            } else {
                this.s0 = null;
            }
            this.precedenceDfa = precedenceDfa;
        }
    }

    @NotNull
    public List<DFAState> getStates() {
        ArrayList<DFAState> result2 = new ArrayList<DFAState>(this.states.keySet());
        Collections.sort(result2, new Comparator<DFAState>(){

            @Override
            public int compare(DFAState o1, DFAState o2) {
                return o1.stateNumber - o2.stateNumber;
            }
        });
        return result2;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(@Nullable String[] tokenNames) {
        if (this.s0 == null) {
            return "";
        }
        DFASerializer serializer = new DFASerializer(this, tokenNames);
        return serializer.toString();
    }

    public String toLexerString() {
        if (this.s0 == null) {
            return "";
        }
        LexerDFASerializer serializer = new LexerDFASerializer(this);
        return serializer.toString();
    }
}

