/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfConsequenceHeader;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VcfConsequence {
    public static final String VCF_INFO_CSQ_NAME = "CSQ";
    VcfConsequenceHeader vcfConsequenceHeader;
    Map<String, String> name2value;

    public static List<VcfConsequence> parse(VcfConsequenceHeader vcfConsequenceHeader, String csqString) {
        ArrayList<VcfConsequence> list2 = new ArrayList<VcfConsequence>();
        if (csqString == null || csqString.isEmpty()) {
            return list2;
        }
        int idx = csqString.indexOf(61);
        if (idx >= 0) {
            if (csqString.startsWith("CSQ=")) {
                throw new RuntimeException("String does not start with 'CSQ=', this is not a CSQ field: " + csqString);
            }
            csqString = csqString.substring(idx);
        }
        for (String csq : csqString.split(",")) {
            list2.add(new VcfConsequence(vcfConsequenceHeader, csq));
        }
        return list2;
    }

    public static List<VcfConsequence> parse(VcfConsequenceHeader vcfConsequenceHeader, VcfEntry ve) {
        return VcfConsequence.parse(vcfConsequenceHeader, ve.getInfo(VCF_INFO_CSQ_NAME));
    }

    public VcfConsequence(VcfConsequenceHeader vcfConsequenceHeader, String csqString) {
        this.vcfConsequenceHeader = vcfConsequenceHeader;
        this.parseSingle(csqString);
    }

    public String get(String fieldName) {
        return this.name2value.get(fieldName);
    }

    public String getConsequence() {
        return this.get("Consequence");
    }

    public String getFeature() {
        return this.get("Feature");
    }

    public String getHgvsDna() {
        return this.get("HGVSc");
    }

    public String getHgvsProt() {
        return this.get("HGVSp");
    }

    void parseSingle(String csqString) {
        try {
            String[] fieldNames = this.vcfConsequenceHeader.getFieldNames();
            this.name2value = new HashMap<String, String>();
            String[] fieldValues = csqString.split("\\|", -1);
            for (int i = 0; i < fieldValues.length; ++i) {
                this.name2value.put(fieldNames[i], fieldValues[i]);
            }
        }
        catch (Exception e) {
            Gpr.debug("Error parsing\n\tCSQ string: " + csqString);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] fieldNames = this.vcfConsequenceHeader.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fieldNames[i] + ": " + this.get(fieldNames[i]));
        }
        return sb.toString();
    }
}

