/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.util;

import java.util.Iterator;

public class CombinatorialIterator
implements Iterable<int[]>,
Iterator<int[]> {
    int[] next;
    int[] max;
    int[] min;
    boolean inc;
    boolean finished;

    public CombinatorialIterator(int size2) {
        this.next = new int[size2];
        this.max = new int[size2];
        this.min = new int[size2];
    }

    @Override
    public boolean hasNext() {
        if (this.inc) {
            this.inc();
        }
        return !this.finished;
    }

    public void inc() {
        this.inc = false;
        for (int i = 0; i < this.next.length; ++i) {
            if (this.next[i] < this.max[i]) {
                int n = i;
                this.next[n] = this.next[n] + 1;
                return;
            }
            this.next[i] = this.min[i];
        }
        this.finished = true;
    }

    @Override
    public Iterator<int[]> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int[] next() {
        if (this.inc) {
            this.inc();
        }
        if (!this.hasNext()) {
            return null;
        }
        this.inc = true;
        return this.next;
    }

    @Override
    public void remove() {
    }

    void reset() {
        this.inc = false;
        this.finished = false;
        for (int i = 0; i < this.next.length; ++i) {
            this.next[i] = this.min[i];
        }
    }

    public void set(int idx, int min2, int max2) {
        if (max2 <= min2) {
            throw new RuntimeException("Cannot initialize 'max' less or equal than 'min'. min = " + min2 + ", max = " + max2);
        }
        this.min[idx] = min2;
        this.max[idx] = max2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i = 0; i < this.next.length; ++i) {
            sb.append((i > 0 ? ", " : "") + this.next[i]);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

