/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats.plot;

import com.googlecode.charts4j.AbstractAxisChart;
import com.googlecode.charts4j.AxisLabelsFactory;
import com.googlecode.charts4j.BarChartPlot;
import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.GCharts;
import com.googlecode.charts4j.LineChart;
import com.googlecode.charts4j.Plot;
import com.googlecode.charts4j.Plots;
import java.util.ArrayList;

public class GooglePlot {
    public static final int MAX_DATA_POINTS = 300;
    double[] x;
    double[] y;
    int numberLabelsXaxis = 10;
    int barWidth = 8;
    int barSpace = 2;
    int plotSizeY = 300;
    int plotSizeX = 800;
    String title = "";
    String xAxisLabel = "";
    String yAxisLabel = "";
    ArrayList<Integer> dataList;
    ArrayList<String> labelList;
    double minX;
    double maxX;
    double minY;
    double maxY;

    public GooglePlot(double[] x2, double[] y, String title, String xAxisLabel, String yAxisLabel) {
        this.x = x2;
        this.y = y;
        this.title = title;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
    }

    void decorate(AbstractAxisChart chart) {
        chart.setTitle(this.title);
        chart.setSize(this.plotSizeX, this.plotSizeY);
        double gridx = (this.maxX - this.minX) / 10.0;
        double gridy = (this.maxY - this.minY) / 10.0;
        if (gridx > 0.0 && gridy > 0.0) {
            chart.setGrid((this.maxX - this.minX) / 10.0, (this.maxY - this.minY) / 10.0, 3, 2);
        }
        chart.addXAxisLabels(AxisLabelsFactory.newAxisLabels(this.labelList));
        chart.addXAxisLabels(AxisLabelsFactory.newAxisLabels((String)this.xAxisLabel, (double)50.0));
        chart.addYAxisLabels(AxisLabelsFactory.newNumericRangeAxisLabels((double)this.minY, (double)this.maxY));
        chart.addYAxisLabels(AxisLabelsFactory.newAxisLabels((String)this.yAxisLabel, (double)50.0));
    }

    void prepareData() {
        int numPoints = Math.min(300, this.x.length);
        if (this.x.length > numPoints) {
            this.subsample(numPoints);
        }
        this.minX = Double.MAX_VALUE;
        this.maxX = Double.MIN_VALUE;
        this.minY = Double.MAX_VALUE;
        this.maxY = Double.MIN_VALUE;
        for (int i = 0; i < this.x.length && i < numPoints; ++i) {
            double xx = this.x[i];
            this.minX = Math.min(this.minX, xx);
            this.maxX = Math.max(this.maxX, xx);
            double yy = this.y[i];
            this.minY = Math.min(this.minY, yy);
            this.maxY = Math.max(this.maxY, yy);
        }
        if (this.minY == this.maxY) {
            this.minY = 0.0;
        }
        this.dataList = new ArrayList();
        this.labelList = new ArrayList();
        int labelEvery = Math.max(numPoints / this.numberLabelsXaxis, 10);
        for (int i = 0; i < numPoints; ++i) {
            double xx = this.x[i];
            if (i % labelEvery == 0 || i == this.x.length - 1 || i == numPoints - 1) {
                this.labelList.add(Double.toString(xx));
            } else {
                this.labelList.add("");
            }
            double yy = this.y[i];
            int scaledY = (int)(100.0 * (yy - this.minY) / (this.maxY - this.minY));
            this.dataList.add(scaledY);
        }
    }

    void subsample(int numberOfPoints) {
        double[] xx = new double[numberOfPoints];
        int[] count2 = new int[numberOfPoints];
        double[] yy = new double[numberOfPoints];
        for (int i = 0; i < this.x.length; ++i) {
            int j;
            int n = j = i * numberOfPoints / this.x.length;
            xx[n] = xx[n] + this.x[i];
            int n2 = j;
            yy[n2] = yy[n2] + this.y[i];
            int n3 = j;
            count2[n3] = count2[n3] + 1;
        }
        for (int j = 0; j < xx.length; ++j) {
            if (count2[j] <= 1) continue;
            int n = j;
            xx[n] = xx[n] / (double)count2[j];
            int n4 = j;
            yy[n4] = yy[n4] / (double)count2[j];
        }
        this.x = xx;
        this.y = yy;
    }

    public String toURLString() {
        this.prepareData();
        BarChartPlot chart = Plots.newBarChartPlot((Data)Data.newData(this.dataList));
        LineChart achart = GCharts.newLineChart((Plot[])new Plot[]{chart});
        this.decorate((AbstractAxisChart)achart);
        return achart.toURLString();
    }
}

