/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats.plot;

import ca.mcgill.mcb.pcingola.stats.plot.GoogleLineChart;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;

public class GoogleBarChart
extends GoogleLineChart {
    public GoogleBarChart(String name) {
        super(name);
    }

    public GoogleBarChart(String name, int width, int height) {
        super(name, width, height);
    }

    public void percentColumns() {
        ArrayList<ArrayList<String>> newColumns = new ArrayList<ArrayList<String>>();
        for (ArrayList col : this.columns) {
            newColumns.add(this.percentColumns(col));
        }
        this.columns = newColumns;
    }

    public ArrayList<String> percentColumns(ArrayList<String> col) {
        ArrayList<String> newCol = new ArrayList<String>(col.size());
        double total = 0.0;
        for (String d : col) {
            total += Gpr.parseDoubleSafe(d);
        }
        for (String d : col) {
            newCol.add("" + 100.0 * Gpr.parseDoubleSafe(d) / total);
        }
        return newCol;
    }

    @Override
    public String toStringHtmlHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\" src=\"http://www.google.com/jsapi\"></script>");
        sb.append("<script type=\"text/javascript\"> google.load('visualization', '1', {packages: ['corechart']}); </script>\n");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("\tfunction draw_" + this.id + "() {\n");
        sb.append("\t\tvar data = google.visualization.arrayToDataTable([\n");
        sb.append("\t[ '' , ");
        int i = 0;
        for (String ct : this.columnTitltes) {
            sb.append((i > 0 ? "," : "") + "'" + ct + "'");
            ++i;
        }
        sb.append("]\n");
        int maxLen = this.maxColumnLength();
        for (i = 0; i < maxLen; ++i) {
            String lab = this.getXLabel(i);
            if (lab != null) {
                lab = "'" + lab + "'";
            }
            sb.append("\t,[ " + lab);
            for (int j = 0; j < this.columns.size(); ++j) {
                sb.append("," + this.getValue(i, j));
            }
            sb.append("]\n");
        }
        sb.append("\t\t]);\n");
        sb.append("\t\tvar ac = new google.visualization.ColumnChart(document.getElementById('visualization_" + this.id + "'));\n");
        sb.append("\t\tac.draw(data, { title : '" + this.title + "', isStacked: " + this.stacked + ", width: " + this.width + ", height: " + this.height + ", vAxis: {title: \"" + this.vAxis + "\"}, hAxis: {title: \"" + this.hAxis + "\"} });\n");
        sb.append("\t\t}\n");
        sb.append("\tgoogle.setOnLoadCallback(draw_" + this.id + ");\n");
        sb.append("</script>\n");
        sb.append("\n");
        return sb.toString();
    }
}

