/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.stats.GeneCountByTypeTable;
import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.stats.plot.GoogleGenePercentBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class VariantEffectStats
implements SamplingStats<VariantEffect> {
    public static final String CHANGE_SEPARATOR = "\t";
    boolean useSequenceOntology = false;
    int aaChangeCountMax = Integer.MIN_VALUE;
    int codonChangeCountMax = Integer.MIN_VALUE;
    int countWarnings = 0;
    int countErrors = 0;
    Genome genome;
    CountByType countByEffect;
    CountByType countByCodon;
    CountByType countByAa;
    CountByType countByGeneRegion;
    CountByType countByImpact;
    CountByType countByFunctionalClass;
    CountByType countByBioType;
    HashSet<String> codonSet;
    HashSet<String> aaSet;
    HashSet<String> geneSet;
    GeneCountByTypeTable geneCountByRegionTable;
    GeneCountByTypeTable geneCountByImpactTable;
    GeneCountByTypeTable geneCountByEffectTable;

    public VariantEffectStats(Genome genome) {
        this.genome = genome;
        this.countByEffect = new CountByType();
        this.countByCodon = new CountByType();
        this.countByAa = new CountByType();
        this.countByGeneRegion = new CountByType();
        this.countByImpact = new CountByType();
        this.countByFunctionalClass = new CountByType();
        this.codonSet = new HashSet();
        this.aaSet = new HashSet();
        this.geneSet = new HashSet();
        this.geneCountByRegionTable = new GeneCountByTypeTable();
        this.geneCountByEffectTable = new GeneCountByTypeTable();
        this.geneCountByImpactTable = new GeneCountByTypeTable();
    }

    private String changeKey(String oldItem, String newItem) {
        return oldItem + CHANGE_SEPARATOR + newItem;
    }

    public String getAaChangeColor(String oldAa, String newAa) {
        return this.countByAa.getColorHtml(this.changeKey(oldAa, newAa));
    }

    public long getAaChangeCount(String oldAa, String newAa) {
        return this.countByAa.get(this.changeKey(oldAa, newAa));
    }

    public List<String> getAaList() {
        ArrayList<String> aas = new ArrayList<String>();
        aas.addAll(this.aaSet);
        Collections.sort(aas);
        return aas;
    }

    public String getCodonChangeColor(String oldCodon, String newCodon) {
        return this.countByCodon.getColorHtml(this.changeKey(oldCodon, newCodon));
    }

    public long getCodonChangeCount(String oldCodon, String newCodon) {
        return this.countByCodon.get(this.changeKey(oldCodon, newCodon));
    }

    public List<String> getCodonList() {
        ArrayList<String> codons = new ArrayList<String>();
        codons.addAll(this.codonSet);
        Collections.sort(codons);
        return codons;
    }

    public CountByType getCountByEffect() {
        return this.countByEffect;
    }

    public CountByType getCountByFunctionalClass() {
        return this.countByFunctionalClass;
    }

    public CountByType getCountByGeneRegion() {
        return this.countByGeneRegion;
    }

    public CountByType getCountByImpact() {
        return this.countByImpact;
    }

    public int getCountErrors() {
        return this.countErrors;
    }

    public int getCountWarnings() {
        return this.countWarnings;
    }

    public GeneCountByTypeTable getGeneCountByEffectTable() {
        return this.geneCountByEffectTable;
    }

    public GeneCountByTypeTable getGeneCountByImpactTable() {
        return this.geneCountByImpactTable;
    }

    public GeneCountByTypeTable getGeneCountByRegionTable() {
        return this.geneCountByRegionTable;
    }

    public String getPlotGene() {
        GoogleGenePercentBar gb = new GoogleGenePercentBar("Variations", "", "%", 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.INTERGENIC)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.UPSTREAM)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.UTR_5_PRIME)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.EXON)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.SPLICE_SITE_DONOR)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.INTRON)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.SPLICE_SITE_ACCEPTOR)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.UTR_3_PRIME)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)EffectType.DOWNSTREAM)));
        return gb.toURLString();
    }

    public double getSilentRatio() {
        long mis = this.countByFunctionalClass.get(VariantEffect.FunctionalClass.MISSENSE.toString());
        long silent = this.countByFunctionalClass.get(VariantEffect.FunctionalClass.SILENT.toString());
        if (silent == 0L) {
            return 0.0;
        }
        return (double)mis / (double)silent;
    }

    @Override
    public boolean hasData() {
        return this.countByEffect.hasData();
    }

    @Override
    public void sample(VariantEffect variantEffect) {
        int i;
        int max2;
        Marker marker;
        String effect;
        if (variantEffect.hasWarning()) {
            ++this.countWarnings;
        }
        if (variantEffect.hasError()) {
            ++this.countErrors;
        }
        if ((effect = variantEffect.getEffectTypeString(this.useSequenceOntology)) == null || effect.isEmpty()) {
            return;
        }
        this.countByEffect.inc(effect);
        String geneRegion = variantEffect.getGeneRegion();
        this.countByGeneRegion.inc(geneRegion);
        String impact = variantEffect.getEffectImpact().toString();
        this.countByImpact.inc(impact);
        VariantEffect.FunctionalClass fc = variantEffect.getFunctionalClass();
        if (fc != VariantEffect.FunctionalClass.NONE) {
            this.countByFunctionalClass.inc(fc.toString());
        }
        if ((marker = variantEffect.getMarker()) != null) {
            Gene gene = variantEffect.getGene();
            Transcript tr = variantEffect.getTranscript();
            if (tr != null && gene != null) {
                this.geneCountByEffectTable.sample(gene, tr, effect, variantEffect);
                this.geneCountByRegionTable.sample(gene, tr, geneRegion, variantEffect);
                this.geneCountByImpactTable.sample(gene, tr, variantEffect.getEffectImpact().toString(), variantEffect);
            }
        }
        if (variantEffect.getCodonsRef() != null && variantEffect.getCodonsRef().length() > 0) {
            String[] oldCodons = this.split(variantEffect.getCodonsRef(), 3);
            String[] newCodons = this.split(variantEffect.getCodonsAlt(), 3);
            max2 = Math.max(oldCodons.length, newCodons.length);
            for (i = 0; i < max2; ++i) {
                String oldCodon = "-";
                String newCodon = "-";
                if (i < oldCodons.length) {
                    oldCodon = oldCodons[i].toUpperCase();
                }
                if (i < newCodons.length) {
                    newCodon = newCodons[i].toUpperCase();
                }
                String codonChangeKey = this.changeKey(oldCodon, newCodon);
                this.codonSet.add(oldCodon);
                this.codonSet.add(newCodon);
                this.countByCodon.inc(codonChangeKey);
            }
        }
        if (variantEffect.getAaRef() != null && variantEffect.getAaRef().length() > 0) {
            String[] oldAas = this.split(variantEffect.getAaRef(), 1);
            String[] newAas = this.split(variantEffect.getAaAlt(), 1);
            max2 = Math.max(oldAas.length, newAas.length);
            for (i = 0; i < max2; ++i) {
                String oldAa = "-";
                String newAa = "-";
                if (i < oldAas.length) {
                    oldAa = oldAas[i].toUpperCase();
                }
                if (i < newAas.length) {
                    newAa = newAas[i].toUpperCase();
                }
                String aaChangeKey = this.changeKey(oldAa, newAa);
                this.aaSet.add(oldAa);
                this.aaSet.add(newAa);
                this.countByAa.inc(aaChangeKey);
            }
        }
    }

    public void setUseSequenceOntology(boolean useSequenceOntology) {
        this.useSequenceOntology = useSequenceOntology;
    }

    String[] split(String str, int size2) {
        int numStr = str.length() / size2;
        String[] splitStr = new String[numStr];
        char[] chars = str.toCharArray();
        int i = 0;
        for (int h = 0; i < chars.length && h < splitStr.length; ++h) {
            String newStr = "";
            for (int j = 0; j < size2 && i < chars.length; ++j, ++i) {
                newStr = newStr + chars[i];
            }
            splitStr[h] = newStr;
        }
        return splitStr;
    }
}

