/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.List;

public class TsTvStats
implements SamplingStats<VcfEntry> {
    static int[] GENOTYPE_SINGLE_ALT_CHANGE = new int[]{1};
    List<String> sampleNames;
    long[] countTs;
    long[] countTv;

    public long getTransitions() {
        if (this.countTs == null) {
            return 0L;
        }
        long sum2 = 0L;
        for (int i = 0; i < this.countTs.length; ++i) {
            sum2 += this.countTs[i];
        }
        return sum2;
    }

    public long getTransversions() {
        if (this.countTv == null) {
            return 0L;
        }
        long sum2 = 0L;
        for (int i = 0; i < this.countTv.length; ++i) {
            sum2 += this.countTv[i];
        }
        return sum2;
    }

    public double getTsTvRatio() {
        double ts = this.getTransitions();
        double tv = this.getTransversions();
        return tv > 0.0 ? ts / tv : 0.0;
    }

    @Override
    public boolean hasData() {
        return this.countTs != null;
    }

    public boolean isTransition(String ref, String alt) {
        if (ref.equals("A") && alt.equals("G")) {
            return true;
        }
        if (ref.equals("C") && alt.equals("T")) {
            return true;
        }
        if (ref.equals("G") && alt.equals("A")) {
            return true;
        }
        return ref.equals("T") && alt.equals("C");
    }

    public boolean isTranversion(String ref, String alt) {
        if (ref.equals("A") && (alt.equals("C") || alt.equals("T"))) {
            return true;
        }
        if (ref.equals("C") && (alt.equals("A") || alt.equals("G"))) {
            return true;
        }
        if (ref.equals("G") && (alt.equals("C") || alt.equals("T"))) {
            return true;
        }
        return ref.equals("T") && (alt.equals("A") || alt.equals("G"));
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
        }
        if (!vcfEntry.isVariant() || !vcfEntry.isSnp()) {
            return;
        }
        int genotypes = vcfEntry.getVcfGenotypes().size();
        if (this.countTs == null) {
            int size2 = Math.max(genotypes, 1);
            this.countTs = new long[size2];
            this.countTv = new long[size2];
        }
        if (genotypes > 0) {
            int sampleNum = 0;
            for (VcfGenotype vcfGenotype : vcfEntry) {
                if (sampleNum >= this.countTs.length) {
                    Gpr.debug("WARNING: VCF entry has more genotype fields than expected (expected: " + this.countTs.length + ", number of genotypes: " + sampleNum + ").\n" + vcfEntry);
                } else if (vcfGenotype.isVariant()) {
                    String[] alts = vcfEntry.getAlts();
                    int[] gens = vcfGenotype.getGenotype();
                    if (gens == null) {
                        gens = GENOTYPE_SINGLE_ALT_CHANGE;
                    }
                    for (int gen : gens) {
                        String alt;
                        if (gen <= 0) continue;
                        String ref = vcfEntry.getRef();
                        if (this.isTransition(ref, alt = alts[gen - 1])) {
                            int n = sampleNum;
                            this.countTs[n] = this.countTs[n] + 1L;
                            continue;
                        }
                        if (!this.isTranversion(ref, alt)) continue;
                        int n = sampleNum;
                        this.countTv[n] = this.countTv[n] + 1L;
                    }
                }
                ++sampleNum;
            }
        } else {
            String ref = vcfEntry.getRef();
            for (String alt : vcfEntry.getAlts()) {
                if (ref.equals(alt)) continue;
                if (this.isTransition(ref, alt)) {
                    this.countTs[0] = this.countTs[0] + 1L;
                    continue;
                }
                if (!this.isTranversion(ref, alt)) continue;
                this.countTv[0] = this.countTv[0] + 1L;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            int i;
            sb.append("Sample ,");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(sname + ",");
                }
            }
            sb.append("Total");
            sb.append("\n");
            long sumTs = 0L;
            sb.append("Transitions ,");
            for (int i2 = 0; i2 < this.countTs.length; ++i2) {
                sb.append(this.countTs[i2] + ",");
                sumTs += this.countTs[i2];
            }
            sb.append(sumTs);
            sb.append("\n");
            long sumTv = 0L;
            sb.append("Transversions ,");
            for (i = 0; i < this.countTv.length; ++i) {
                sb.append(this.countTv[i] + ",");
                sumTv += this.countTv[i];
            }
            sb.append(sumTv);
            sb.append("\n");
            sb.append("Ts/Tv ,");
            for (i = 0; i < this.countTv.length; ++i) {
                double tstv = (double)this.countTs[i] / (double)this.countTv[i];
                sb.append(String.format("%.3f,", tstv));
            }
            double tstv = (double)sumTs / (double)sumTv;
            sb.append(String.format("%.3f", tstv));
            sb.append("\n");
        }
        return sb.toString();
    }
}

