/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.plot.GoogleHistogram;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class ChrPosStats {
    int maxBins = 300;
    String name;
    int length;
    int factor = 1;
    int[] count;
    int total;

    public ChrPosStats(String chrName, int length) {
        this.name = chrName;
        this.length = length;
        this.total = 0;
        this.factor = 1;
        this.factor = 1;
        while (length / this.factor > this.maxBins) {
            this.factor *= 10;
        }
        int len = length / this.factor + 1;
        this.init(len);
    }

    String factorStr() {
        if (this.factor > 1000000000) {
            return this.factor / 1000000000 + "Gb";
        }
        if (this.factor > 1000000) {
            return this.factor / 1000000 + "Mb";
        }
        if (this.factor > 1000) {
            return this.factor / 1000 + "Kb";
        }
        return this.factor + "b";
    }

    public int getCount(int idx) {
        return this.count[idx];
    }

    public int getTotal() {
        return this.total;
    }

    void init(int len) {
        this.count = new int[len];
        for (int i = 0; i < this.count.length; ++i) {
            this.count[i] = 0;
        }
    }

    public int[] posArray() {
        int[] pos = new int[this.count.length];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = i * this.factor;
        }
        return pos;
    }

    public void sample(int position) {
        if (this.length <= 1) {
            return;
        }
        int i = position / this.factor;
        if (i >= 0 && i < this.count.length) {
            int n = i;
            this.count[n] = this.count[n] + 1;
            ++this.total;
        } else {
            Gpr.debug("Error counting samples on chromosome '" + this.name + "'. Position '" + position + "' => count[" + i + "]  (count.length: " + this.count.length + ", factor: " + this.factor + ", chrLength: " + this.length + ").");
        }
    }

    public int size() {
        return this.count.length;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + ", Position,");
        int[] pos = this.posArray();
        for (i = 0; i < this.count.length; ++i) {
            sb.append(pos[i] + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("\n");
        sb.append(this.name + ",Count,");
        for (i = 0; i < this.count.length; ++i) {
            sb.append(this.count[i] + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("\n");
        return sb.toString();
    }

    public String toStringHistoPlot(String title, String xAxisLabel, String yAxisLabel) {
        int[] pos = this.posArray();
        GoogleHistogram gghisto = new GoogleHistogram(pos, this.count, title, xAxisLabel, yAxisLabel + "/" + this.factorStr());
        return gghisto.toURLString();
    }
}

