/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.testCases;

import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdAnnotate;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesZzz
extends TestCase {
    public static boolean debug;
    public static boolean verbose;
    protected String[] defaultExtraArgs = new String[]{"-sorted"};

    public List<VcfEntry> annotate(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSiftCmdAnnotate snpSiftAnnotate = new SnpSiftCmdAnnotate(args);
        snpSiftAnnotate.setDebug(debug);
        snpSiftAnnotate.setVerbose(verbose);
        snpSiftAnnotate.setSuppressOutput(!verbose);
        List<VcfEntry> results = snpSiftAnnotate.run(true);
        Assert.assertTrue(results != null);
        Assert.assertTrue(results.size() > 0);
        return results;
    }

    public String annotateOut(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSiftCmdAnnotate snpSift = new SnpSiftCmdAnnotate(args);
        snpSift.setDebug(debug);
        snpSift.setVerbose(verbose);
        snpSift.setSaveOutput(true);
        snpSift.run();
        return snpSift.getOutput();
    }

    public void annotateTest(String dbFileName, String fileName) {
        this.annotateTest(dbFileName, fileName, null);
    }

    public void annotateTest(String dbFileName, String fileName, String[] extraArgs) {
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        for (VcfEntry vcf : results) {
            String idstr = vcf.getId();
            String expectedIds = vcf.getInfo("EXP_IDS");
            if (expectedIds != null) {
                if ((expectedIds = expectedIds.replace('|', ';')).equals(".")) {
                    expectedIds = "";
                }
                Assert.assertEquals("Expected ID does not match annotated ID", expectedIds, idstr);
                continue;
            }
            TestCasesZzz.fail("EXP_IDS (expected ids) INFO field missing in " + fileName + ", entry:\n" + vcf);
        }
    }

    protected String[] argsList(String dbFileName, String fileName, String[] extraArgs) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.defaultExtraArgs != null) {
            for (String arg : this.defaultExtraArgs) {
                argsList.add(arg);
            }
        }
        if (extraArgs != null) {
            for (String arg : extraArgs) {
                argsList.add(arg);
            }
        }
        argsList.add(dbFileName);
        argsList.add(fileName);
        return argsList.toArray(new String[0]);
    }

    public void test_37() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_37.vcf";
        String fileName = "./test/annotate_37.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    static {
        verbose = debug = false;
    }
}

