/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.testCases;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdVarType;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesVarType
extends TestCase {
    public static boolean verbose = false;

    void checkAllVarType(String file, String varTypeExpected) {
        SnpSiftCmdVarType varType = new SnpSiftCmdVarType(null);
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry ve : vcf) {
            varType.annotate(ve);
            if (!ve.getInfoFlag(varTypeExpected)) {
                System.err.println("Eror in file '" + file + "':\n" + ve);
            }
            Assert.assertEquals(true, ve.getInfoFlag(varTypeExpected));
        }
    }

    void checkVarTypeField(String file, String varTypeExpected) {
        SnpSiftCmdVarType varType = new SnpSiftCmdVarType(null);
        VcfFileIterator vcf = new VcfFileIterator(file);
        for (VcfEntry ve : vcf) {
            varType.annotate(ve);
            String varTypeAnnotated = ve.getInfo("VARTYPE");
            Assert.assertEquals(varTypeExpected, varTypeAnnotated);
        }
    }

    public void test_01_SNP() {
        this.checkAllVarType("test/varType_snp.vcf", "SNP");
    }

    public void test_02_MNP() {
        this.checkAllVarType("test/varType_mnp.vcf", "MNP");
    }

    public void test_03_INS() {
        this.checkAllVarType("test/varType_ins.vcf", "INS");
    }

    public void test_04_DEL() {
        this.checkAllVarType("test/varType_del.vcf", "DEL");
    }

    public void test_05_multiple() {
        this.checkVarTypeField("test/varType_multiple.vcf", "SNP,INS");
    }
}

