/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.testCases;

import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdSplit;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesSplit
extends TestCase {
    public static boolean debug = false;
    public static boolean verbose = false;

    public void test_01() {
        Gpr.debug("Test");
        String file = "test/test_split_01.vcf";
        new File("test/test_split_01.Y.vcf").delete();
        new File("test/test_split_01.19.vcf").delete();
        String[] args = new String[]{file};
        SnpSiftCmdSplit cmd = new SnpSiftCmdSplit(args);
        cmd.setVerbose(verbose);
        cmd.setDebug(debug);
        cmd.run();
        String expected = Gpr.readFile("test/test_split_01.Y.expected.vcf");
        String actual = Gpr.readFile("test/test_split_01.Y.vcf");
        Assert.assertEquals(expected, actual);
        expected = Gpr.readFile("test/test_split_01.19.expected.vcf");
        actual = Gpr.readFile("test/test_split_01.19.vcf");
        Assert.assertEquals(expected, actual);
    }

    public void test_02() {
        Gpr.debug("Test");
        int numLines = 2;
        String file = "test/test_split_01.vcf";
        String[] args = new String[]{"-l", numLines + "", file};
        SnpSiftCmdSplit cmd = new SnpSiftCmdSplit(args);
        cmd.setVerbose(verbose);
        cmd.setDebug(debug);
        cmd.run();
        for (String splitFile : cmd.getFileNames()) {
            int n = Gpr.countLines(splitFile);
            if (debug) {
                Gpr.debug("Checking file '" + splitFile + "'\tnumber of lines: " + n);
            }
            Assert.assertEquals(numLines + 1, n);
        }
    }

    public void test_03() {
        Gpr.debug("Test");
        String file = "test/test_split_01.vcf";
        String originalFile = Gpr.readFile(file);
        new File("test/test_split_01.Y.vcf").delete();
        new File("test/test_split_01.19.vcf").delete();
        String[] args = new String[]{file};
        SnpSiftCmdSplit cmd = new SnpSiftCmdSplit(args);
        cmd.setVerbose(verbose);
        cmd.setDebug(debug);
        cmd.run();
        String[] argsJoin = new String[]{"-j", "test/test_split_01.Y.vcf", "test/test_split_01.19.vcf"};
        cmd = new SnpSiftCmdSplit(argsJoin);
        cmd.setVerbose(true);
        cmd.setDebug(debug);
        String joinedFile = cmd.join(true);
        Assert.assertEquals(originalFile, joinedFile);
    }
}

